/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.ResponseMetadata;
import java.util.LinkedHashMap;
import java.util.Map;

public class ResponseMetadataCache {
    private final InternalCache internalCache;

    public ResponseMetadataCache(int maxEntries) {
        this.internalCache = new InternalCache(maxEntries);
    }

    public synchronized void add(Object obj, ResponseMetadata metadata) {
        if (obj == null) {
            return;
        }
        this.internalCache.put(System.identityHashCode(obj), metadata);
    }

    public ResponseMetadata get(Object obj) {
        return (ResponseMetadata)this.internalCache.get(System.identityHashCode(obj));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class InternalCache
    extends LinkedHashMap<Integer, ResponseMetadata> {
        private int maxSize;

        public InternalCache(int maxSize) {
            super(maxSize);
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.maxSize;
        }
    }
}

