/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitosync.model.ListRecordsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ListRecordsRequestMarshaller
implements Marshaller<Request<ListRecordsRequest>, ListRecordsRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    public Request<ListRecordsRequest> marshall(ListRecordsRequest listRecordsRequest) {
        String value;
        String name;
        if (listRecordsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listRecordsRequest, "AmazonCognitoSync");
        String target = "AWSCognitoSyncService.ListRecords";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        if (DYNAMIC_QUERY_PARAMS.containsKey("IdentityPoolId")) {
            name = DYNAMIC_QUERY_PARAMS.get("IdentityPoolId");
            String string = value = listRecordsRequest.getIdentityPoolId() == null ? null : StringUtils.fromString((String)listRecordsRequest.getIdentityPoolId());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", listRecordsRequest.getIdentityPoolId() == null ? "" : StringUtils.fromString((String)listRecordsRequest.getIdentityPoolId()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("IdentityId")) {
            name = DYNAMIC_QUERY_PARAMS.get("IdentityId");
            String string = value = listRecordsRequest.getIdentityId() == null ? null : StringUtils.fromString((String)listRecordsRequest.getIdentityId());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{IdentityId}", listRecordsRequest.getIdentityId() == null ? "" : StringUtils.fromString((String)listRecordsRequest.getIdentityId()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("DatasetName")) {
            name = DYNAMIC_QUERY_PARAMS.get("DatasetName");
            String string = value = listRecordsRequest.getDatasetName() == null ? null : StringUtils.fromString((String)listRecordsRequest.getDatasetName());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{DatasetName}", listRecordsRequest.getDatasetName() == null ? "" : StringUtils.fromString((String)listRecordsRequest.getDatasetName()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("LastSyncCount")) {
            name = DYNAMIC_QUERY_PARAMS.get("LastSyncCount");
            String string = value = listRecordsRequest.getLastSyncCount() == null ? null : StringUtils.fromLong((Long)listRecordsRequest.getLastSyncCount());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{LastSyncCount}", listRecordsRequest.getLastSyncCount() == null ? "" : StringUtils.fromLong((Long)listRecordsRequest.getLastSyncCount()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("NextToken")) {
            name = DYNAMIC_QUERY_PARAMS.get("NextToken");
            String string = value = listRecordsRequest.getNextToken() == null ? null : StringUtils.fromString((String)listRecordsRequest.getNextToken());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{NextToken}", listRecordsRequest.getNextToken() == null ? "" : StringUtils.fromString((String)listRecordsRequest.getNextToken()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("MaxResults")) {
            name = DYNAMIC_QUERY_PARAMS.get("MaxResults");
            String string = value = listRecordsRequest.getMaxResults() == null ? null : StringUtils.fromInteger((Integer)listRecordsRequest.getMaxResults());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{MaxResults}", listRecordsRequest.getMaxResults() == null ? "" : StringUtils.fromInteger((Integer)listRecordsRequest.getMaxResults()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("SyncSessionToken")) {
            name = DYNAMIC_QUERY_PARAMS.get("SyncSessionToken");
            String string = value = listRecordsRequest.getSyncSessionToken() == null ? null : StringUtils.fromString((String)listRecordsRequest.getSyncSessionToken());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{SyncSessionToken}", listRecordsRequest.getSyncSessionToken() == null ? "" : StringUtils.fromString((String)listRecordsRequest.getSyncSessionToken()));
        }
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }

    static {
        String path = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}/records?lastSyncCount={LastSyncCount};maxResults={MaxResults};nextToken={NextToken};syncSessionToken={SyncSessionToken}";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

