/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.DhcpConfiguration;
import com.amazonaws.services.ec2.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DhcpOptions
implements Serializable,
Cloneable {
    private String dhcpOptionsId;
    private ListWithAutoConstructFlag<DhcpConfiguration> dhcpConfigurations;
    private ListWithAutoConstructFlag<Tag> tags;

    public String getDhcpOptionsId() {
        return this.dhcpOptionsId;
    }

    public void setDhcpOptionsId(String dhcpOptionsId) {
        this.dhcpOptionsId = dhcpOptionsId;
    }

    public DhcpOptions withDhcpOptionsId(String dhcpOptionsId) {
        this.dhcpOptionsId = dhcpOptionsId;
        return this;
    }

    public List<DhcpConfiguration> getDhcpConfigurations() {
        if (this.dhcpConfigurations == null) {
            this.dhcpConfigurations = new ListWithAutoConstructFlag();
            this.dhcpConfigurations.setAutoConstruct(true);
        }
        return this.dhcpConfigurations;
    }

    public void setDhcpConfigurations(Collection<DhcpConfiguration> dhcpConfigurations) {
        if (dhcpConfigurations == null) {
            this.dhcpConfigurations = null;
            return;
        }
        ListWithAutoConstructFlag dhcpConfigurationsCopy = new ListWithAutoConstructFlag(dhcpConfigurations.size());
        dhcpConfigurationsCopy.addAll(dhcpConfigurations);
        this.dhcpConfigurations = dhcpConfigurationsCopy;
    }

    public DhcpOptions withDhcpConfigurations(DhcpConfiguration ... dhcpConfigurations) {
        if (this.getDhcpConfigurations() == null) {
            this.setDhcpConfigurations(new ArrayList<DhcpConfiguration>(dhcpConfigurations.length));
        }
        for (DhcpConfiguration value : dhcpConfigurations) {
            this.getDhcpConfigurations().add(value);
        }
        return this;
    }

    public DhcpOptions withDhcpConfigurations(Collection<DhcpConfiguration> dhcpConfigurations) {
        if (dhcpConfigurations == null) {
            this.dhcpConfigurations = null;
        } else {
            ListWithAutoConstructFlag dhcpConfigurationsCopy = new ListWithAutoConstructFlag(dhcpConfigurations.size());
            dhcpConfigurationsCopy.addAll(dhcpConfigurations);
            this.dhcpConfigurations = dhcpConfigurationsCopy;
        }
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public DhcpOptions withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public DhcpOptions withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDhcpOptionsId() != null) {
            sb.append("DhcpOptionsId: " + this.getDhcpOptionsId() + ",");
        }
        if (this.getDhcpConfigurations() != null) {
            sb.append("DhcpConfigurations: " + this.getDhcpConfigurations() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDhcpOptionsId() == null ? 0 : this.getDhcpOptionsId().hashCode());
        hashCode = 31 * hashCode + (this.getDhcpConfigurations() == null ? 0 : this.getDhcpConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DhcpOptions)) {
            return false;
        }
        DhcpOptions other = (DhcpOptions)obj;
        if (other.getDhcpOptionsId() == null ^ this.getDhcpOptionsId() == null) {
            return false;
        }
        if (other.getDhcpOptionsId() != null && !other.getDhcpOptionsId().equals(this.getDhcpOptionsId())) {
            return false;
        }
        if (other.getDhcpConfigurations() == null ^ this.getDhcpConfigurations() == null) {
            return false;
        }
        if (other.getDhcpConfigurations() != null && !other.getDhcpConfigurations().equals(this.getDhcpConfigurations())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public DhcpOptions clone() {
        try {
            return (DhcpOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

