/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.redshift.model.CreateClusterParameterGroupRequest;
import com.amazonaws.services.redshift.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateClusterParameterGroupRequestMarshaller
implements Marshaller<Request<CreateClusterParameterGroupRequest>, CreateClusterParameterGroupRequest> {
    public Request<CreateClusterParameterGroupRequest> marshall(CreateClusterParameterGroupRequest createClusterParameterGroupRequest) {
        if (createClusterParameterGroupRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createClusterParameterGroupRequest, "AmazonRedshift");
        request.addParameter("Action", "CreateClusterParameterGroup");
        request.addParameter("Version", "2012-12-01");
        if (createClusterParameterGroupRequest.getParameterGroupName() != null) {
            request.addParameter("ParameterGroupName", StringUtils.fromString((String)createClusterParameterGroupRequest.getParameterGroupName()));
        }
        if (createClusterParameterGroupRequest.getParameterGroupFamily() != null) {
            request.addParameter("ParameterGroupFamily", StringUtils.fromString((String)createClusterParameterGroupRequest.getParameterGroupFamily()));
        }
        if (createClusterParameterGroupRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createClusterParameterGroupRequest.getDescription()));
        }
        List<Tag> tagsList = createClusterParameterGroupRequest.getTags();
        int tagsListIndex = 1;
        for (Tag tagsListValue : tagsList) {
            Tag tagMember = tagsListValue;
            if (tagMember != null) {
                if (tagMember.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagMember.getKey()));
                }
                if (tagMember.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagMember.getValue()));
                }
            }
            ++tagsListIndex;
        }
        return request;
    }
}

