/*
 * Decompiled with CFR 0.152.
 */
package scalax.collection.mutable;

import java.util.Arrays;
import scala.Equals;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.Util$;
import scala.runtime.BoxesRunTime;
import scalax.collection.mutable.EqHash;
import scalax.collection.mutable.EqHash$;

public abstract class EqHash$class {
    public static final int size(EqHash $this) {
        return $this._size();
    }

    public static void from(EqHash $this, EqHash other) {
        $this.threshold_$eq(other.threshold());
        $this.table_$eq((Object[])other.table().clone());
        $this._size_$eq(other.size());
    }

    public static final int maxCapacity(EqHash $this) {
        return 1 << 31 - $this.step();
    }

    private static final int len(EqHash $this, int capacity) {
        return capacity * $this.step();
    }

    private static final int cap(EqHash $this, int length) {
        return length / $this.step();
    }

    public static final int nextKeyIndex(EqHash $this, int i, int len) {
        int n = i + $this.step();
        return n < len ? n : 0;
    }

    public static final Object maskNull(EqHash $this, Object key) {
        return key == null ? EqHash$.MODULE$.maskedNull() : key;
    }

    public static final Object unmaskNull(EqHash $this, Object key) {
        return key == EqHash$.MODULE$.maskedNull() ? EqHash$.MODULE$.maskedNull() : key;
    }

    private static int capacity(EqHash $this, int sizeHint) {
        int min = EqHash$class.cap($this, (EqHash$class.len($this, 1) + 1) * sizeHint);
        return min < 8 ? 8 : (min > $this.maxCapacity() || min < 0 ? $this.maxCapacity() : Util$.MODULE$.powerOf2(min));
    }

    public static int index(EqHash $this, Object maskedKey, int keyHash, int tabLength) {
        Object[] tab = $this.table();
        int i = keyHash;
        Object item;
        while ((item = tab[i]) != maskedKey) {
            if (item == null) {
                return ~i;
            }
            i = $this.nextKeyIndex(i, tabLength);
        }
        return i;
    }

    public static final int index(EqHash $this, Object key) {
        Object maskedKey = $this.maskNull(key);
        int len = $this.table().length;
        return $this.index(maskedKey, EqHash$.MODULE$.hash(maskedKey, len, $this.step() - 1), len);
    }

    public static void clear(EqHash $this) {
        Arrays.fill($this.table(), null);
        $this._size_$eq(0);
    }

    public static void resize(EqHash $this) {
        Object[] oldTable = $this.table();
        int oldLength = oldTable.length;
        int newLength = 2 * oldLength;
        if (oldLength == 2 * $this.maxCapacity()) {
            if ($this.threshold() == $this.maxCapacity() - 1) {
                throw new IllegalStateException("Capacity exhausted.");
            }
            $this.threshold_$eq($this.maxCapacity() - 1);
        } else if (oldLength < newLength) {
            Object[] newTable = new Object[newLength];
            $this.threshold_$eq(newLength / 3);
            $this.move(oldTable, oldLength, newTable, newLength);
            $this.table_$eq(newTable);
        }
    }

    public static final void closeDeletion(EqHash $this, int index) {
        Object[] tab = $this.table();
        int len = tab.length;
        int s = $this.step();
        int d = index;
        int i = $this.nextKeyIndex(d, len);
        Object item = tab[i];
        while (item != null) {
            int r = EqHash$.MODULE$.hash(item, len, $this.step() - 1);
            if (i < r && (r <= d || d <= i) || r <= d && d <= i) {
                for (int j = 0; j < s; ++j) {
                    tab[d + j] = tab[i + j];
                    tab[i + j] = null;
                }
                d = i;
            }
            i = $this.nextKeyIndex(i, len);
            item = tab[i];
        }
    }

    public static int hashCode(EqHash $this) {
        Object[] tab = $this.table();
        int n = 0;
        return BoxesRunTime.unboxToInt((Object)new EqHash.KeyIndexIterator($this).$div$colon(BoxesRunTime.boxToInteger((int)n), new Serializable($this, tab){
            private final /* synthetic */ EqHash $outer;
            private final Object[] tab$1;

            public final int apply(int x$3, int x$4) {
                return this.apply$mcIII$sp(x$3, x$4);
            }

            public int apply$mcIII$sp(int x$3, int x$4) {
                return x$3 + BoxesRunTime.unboxToInt((Object)this.$outer.elemHashCode().apply((Object)this.tab$1, (Object)BoxesRunTime.boxToInteger((int)x$4)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tab$1 = tab$1;
            }
        }));
    }

    public static boolean equals(EqHash $this, Object other) {
        EqHash eqHash;
        Object object = other;
        boolean bl = object instanceof EqHash && object instanceof TraversableOnce && object instanceof Equals ? ((Equals)(eqHash = (EqHash)object)).canEqual((Object)$this) && ((TraversableOnce)eqHash).size() == ((TraversableOnce)$this).size() && ((TraversableOnce)eqHash).forall((Function1)new Serializable($this){
            private final /* synthetic */ EqHash $outer;

            public final boolean apply(A elem) {
                return this.$outer.containsElem(elem);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }) : false;
        return bl;
    }

    public static void $init$(EqHash $this) {
        $this._size_$eq(0);
        int cap = EqHash$class.capacity($this, $this.sizeHint());
        int length = EqHash$class.len($this, cap);
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)(length / 3)), (Object)new Object[length]);
        if (tuple2 != null) {
            int threshold = tuple2._1$mcI$sp();
            Object[] table = (Object[])tuple2._2();
            int n = threshold;
            if (table != null) {
                Object[] objectArray = table;
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)n), (Object)objectArray);
                $this.scalax$collection$mutable$EqHash$_setter_$scalax$collection$mutable$EqHash$$x$1_$eq(tuple22);
                $this.threshold_$eq($this.scalax$collection$mutable$EqHash$$x$1()._1$mcI$sp());
                $this.table_$eq((Object[])$this.scalax$collection$mutable$EqHash$$x$1()._2());
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }
}

