/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.ser;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.joda.ser.JacksonJodaFormat;
import com.fasterxml.jackson.datatype.joda.ser.JodaDateSerializerBase;
import java.io.IOException;
import java.lang.reflect.Type;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;

public final class LocalTimeSerializer
extends JodaDateSerializerBase<LocalTime> {
    protected static final JacksonJodaFormat DEFAULT_FORMAT = new JacksonJodaFormat(DEFAULT_TIMEONLY_FORMAT);

    public LocalTimeSerializer() {
        this(DEFAULT_FORMAT);
    }

    public LocalTimeSerializer(JacksonJodaFormat format) {
        super(LocalTime.class, format);
    }

    public LocalTimeSerializer withFormat(JacksonJodaFormat formatter) {
        return this._format == formatter ? this : new LocalTimeSerializer(formatter);
    }

    public void serialize(LocalTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (this._useTimestamp(provider)) {
            jgen.writeStartArray();
            jgen.writeNumber(value.hourOfDay().get());
            jgen.writeNumber(value.minuteOfHour().get());
            jgen.writeNumber(value.secondOfMinute().get());
            jgen.writeNumber(value.millisOfSecond().get());
            jgen.writeEndArray();
        } else {
            jgen.writeString(this._format.createFormatter(provider).print((ReadablePartial)value));
        }
    }

    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode(this._useTimestamp(provider) ? "array" : "string", true);
    }
}

