/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.wxpay.bean.WxPayApiData;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.impl.BaseWxPayServiceImpl;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.net.ssl.SSLContext;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import jodd.http.ProxyInfo;
import jodd.http.net.SSLSocketHttpConnectionProvider;
import jodd.http.net.SocketHttpConnectionProvider;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;

public class WxPayServiceJoddHttpImpl
extends BaseWxPayServiceImpl {
    @Override
    public byte[] postForBytes(String url, String requestStr, boolean useKey) throws WxPayException {
        try {
            HttpRequest request = this.buildHttpRequest(url, requestStr, useKey);
            byte[] responseBytes = request.send().bodyBytes();
            String responseString = Base64.getEncoder().encodeToString(responseBytes);
            this.log.info("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e(Base64\u7f16\u7801\u540e)\u3011\uff1a{}", new Object[]{url, requestStr, responseString});
            if (this.getConfig().isIfSaveApiData()) {
                wxApiData.set(new WxPayApiData(url, requestStr, responseString, null));
            }
            return responseBytes;
        }
        catch (Exception e) {
            this.log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{url, requestStr, e.getMessage()});
            wxApiData.set(new WxPayApiData(url, requestStr, null, e.getMessage()));
            throw new WxPayException(e.getMessage(), e);
        }
    }

    @Override
    public String post(String url, String requestStr, boolean useKey) throws WxPayException {
        try {
            HttpRequest request = this.buildHttpRequest(url, requestStr, useKey);
            String responseString = this.getResponseString(request.send());
            this.log.info("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e\u3011\uff1a{}", new Object[]{url, requestStr, responseString});
            if (this.getConfig().isIfSaveApiData()) {
                wxApiData.set(new WxPayApiData(url, requestStr, responseString, null));
            }
            return responseString;
        }
        catch (Exception e) {
            this.log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{url, requestStr, e.getMessage()});
            wxApiData.set(new WxPayApiData(url, requestStr, null, e.getMessage()));
            throw new WxPayException(e.getMessage(), e);
        }
    }

    @Override
    public String postV3(String url, String requestStr) throws WxPayException {
        return null;
    }

    @Override
    public String postV3WithWechatpaySerial(String url, String requestStr) throws WxPayException {
        return null;
    }

    @Override
    public String postV3(String url, HttpPost httpPost) throws WxPayException {
        return null;
    }

    @Override
    public String requestV3(String url, HttpRequestBase httpRequest) throws WxPayException {
        return null;
    }

    @Override
    public String getV3(String url) throws WxPayException {
        return null;
    }

    @Override
    public InputStream downloadV3(String url) throws WxPayException {
        return null;
    }

    private HttpRequest buildHttpRequest(String url, String requestStr, boolean useKey) throws WxPayException {
        SSLSocketHttpConnectionProvider provider;
        HttpRequest request = (HttpRequest)HttpRequest.post((String)url).timeout(this.getConfig().getHttpTimeout()).connectionTimeout(this.getConfig().getHttpConnectionTimeout()).bodyText(requestStr);
        if (useKey) {
            SSLContext sslContext = this.getConfig().getSslContext();
            if (null == sslContext) {
                sslContext = this.getConfig().initSSLContext();
            }
            provider = new SSLSocketHttpConnectionProvider(sslContext);
            request.withConnectionProvider((HttpConnectionProvider)provider);
        }
        if (StringUtils.isNotBlank((CharSequence)this.getConfig().getHttpProxyHost()) && this.getConfig().getHttpProxyPort() > 0) {
            if (StringUtils.isEmpty((CharSequence)this.getConfig().getHttpProxyUsername())) {
                this.getConfig().setHttpProxyUsername("whatever");
            }
            ProxyInfo httpProxy = new ProxyInfo(ProxyInfo.ProxyType.HTTP, this.getConfig().getHttpProxyHost(), this.getConfig().getHttpProxyPort().intValue(), this.getConfig().getHttpProxyUsername(), this.getConfig().getHttpProxyPassword());
            provider = request.connectionProvider();
            if (null == provider) {
                provider = new SocketHttpConnectionProvider();
            }
            provider.useProxy(httpProxy);
            request.withConnectionProvider((HttpConnectionProvider)provider);
        }
        return request;
    }

    private String getResponseString(HttpResponse response) throws WxPayException {
        try {
            this.log.debug("\u3010\u5fae\u4fe1\u670d\u52a1\u5668\u54cd\u5e94\u5934\u4fe1\u606f\u3011\uff1a\n{}", (Object)response.toString(false));
        }
        catch (NullPointerException e) {
            this.log.warn("HttpResponse.toString() \u5c45\u7136\u629b\u51fa\u7a7a\u6307\u9488\u5f02\u5e38\u4e86", (Throwable)e);
        }
        String responseString = response.bodyText();
        if (StringUtils.isBlank((CharSequence)responseString)) {
            throw new WxPayException("\u54cd\u5e94\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)response.charset())) {
            responseString = new String(responseString.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        }
        return responseString;
    }
}

