/*
 * Decompiled with CFR 0.152.
 */
package com.github.javafaker;

import com.github.javafaker.Faker;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.concurrent.TimeUnit;

public class DateAndTime {
    private static final int DEFAULT_MIN_AGE = 18;
    private static final int DEFAULT_MAX_AGE = 65;
    private final Faker faker;

    protected DateAndTime(Faker faker) {
        this.faker = faker;
    }

    public Date future(int atMost, TimeUnit unit) {
        Date now = new Date();
        Date aBitLaterThanNow = new Date(now.getTime() + 1000L);
        return this.future(atMost, unit, aBitLaterThanNow);
    }

    public Date future(int atMost, TimeUnit unit, Date referenceDate) {
        long upperBound = unit.toMillis(atMost);
        long futureMillis = referenceDate.getTime();
        return new Date(futureMillis += 1L + this.faker.random().nextLong(upperBound - 1L));
    }

    public Date past(int atMost, TimeUnit unit) {
        Date now = new Date();
        Date aBitEarlierThanNow = new Date(now.getTime() - 1000L);
        return this.past(atMost, unit, aBitEarlierThanNow);
    }

    public Date past(int atMost, TimeUnit unit, Date referenceDate) {
        long upperBound = unit.toMillis(atMost);
        long futureMillis = referenceDate.getTime();
        return new Date(futureMillis -= 1L + this.faker.random().nextLong(upperBound - 1L));
    }

    public Date between(Date from, Date to) throws IllegalArgumentException {
        if (to.before(from)) {
            throw new IllegalArgumentException("Invalid date range, the upper bound date is before the lower bound.");
        }
        long offsetMillis = this.faker.random().nextLong(to.getTime() - from.getTime());
        return new Date(from.getTime() + offsetMillis);
    }

    public Date birthday() {
        return this.birthday(18, 65);
    }

    public Date birthday(int minAge, int maxAge) {
        int currentYear = Calendar.getInstance().get(1);
        GregorianCalendar from = new GregorianCalendar(currentYear - maxAge, 0, 1);
        GregorianCalendar to = new GregorianCalendar(currentYear - minAge, 11, 31);
        return this.between(from.getTime(), to.getTime());
    }
}

