/*
 * Decompiled with CFR 0.152.
 */
package com.github.javafaker;

import com.github.javafaker.Faker;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Lorem {
    private final Faker faker;
    private static final char[] characters;

    protected Lorem(Faker faker) {
        this.faker = faker;
    }

    public char character() {
        return this.character(false);
    }

    public char character(boolean includeUppercase) {
        return this.characters(1).charAt(0);
    }

    public String characters() {
        return this.characters(255, false);
    }

    public String characters(boolean includeUppercase) {
        return this.characters(255, false);
    }

    public String characters(int minimumLength, int maximumLength) {
        return this.characters(this.faker.random().nextInt(maximumLength - minimumLength) + minimumLength, false);
    }

    public String characters(int minimumLength, int maximumLength, boolean includeUppercase) {
        return this.characters(this.faker.random().nextInt(maximumLength - minimumLength) + minimumLength, includeUppercase);
    }

    public String characters(int fixedNumberOfCharacters) {
        return this.characters(fixedNumberOfCharacters, false);
    }

    public String characters(int fixedNumberOfCharacters, boolean includeUppercase) {
        if (fixedNumberOfCharacters < 1) {
            return "";
        }
        char[] buffer = new char[fixedNumberOfCharacters];
        for (int i = 0; i < buffer.length; ++i) {
            char randomCharacter = characters[this.faker.random().nextInt(characters.length)];
            if (includeUppercase && this.faker.bool().bool()) {
                randomCharacter = Character.toUpperCase(randomCharacter);
            }
            buffer[i] = randomCharacter;
        }
        return new String(buffer);
    }

    public List<String> words(int num) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (int i = 0; i < num; ++i) {
            returnList.add(this.word());
        }
        return returnList;
    }

    public List<String> words() {
        return this.words(3);
    }

    public String word() {
        return this.faker.fakeValuesService().resolve("lorem.words", this, this.faker);
    }

    public String sentence() {
        return this.sentence(3);
    }

    public String sentence(int wordCount) {
        return this.sentence(wordCount, 6);
    }

    public String sentence(int wordCount, int randomWordsToAdd) {
        int numberOfWordsToAdd = randomWordsToAdd == 0 ? 0 : this.faker.random().nextInt(randomWordsToAdd);
        return StringUtils.capitalize((String)(StringUtils.join(this.words(wordCount + numberOfWordsToAdd), (String)" ") + "."));
    }

    public List<String> sentences(int sentenceCount) {
        ArrayList<String> sentences = new ArrayList<String>(sentenceCount);
        for (int i = 0; i < sentenceCount; ++i) {
            sentences.add(this.sentence());
        }
        return sentences;
    }

    public String paragraph(int sentenceCount) {
        return StringUtils.join(this.sentences(sentenceCount + this.faker.random().nextInt(3)), (String)" ");
    }

    public String paragraph() {
        return this.paragraph(3);
    }

    public List<String> paragraphs(int paragraphCount) {
        ArrayList<String> paragraphs = new ArrayList<String>(paragraphCount);
        for (int i = 0; i < paragraphCount; ++i) {
            paragraphs.add(this.paragraph());
        }
        return paragraphs;
    }

    public String fixedString(int numberOfLetters) {
        StringBuilder builder = new StringBuilder();
        while (builder.length() < numberOfLetters) {
            builder.append(this.sentence());
        }
        return StringUtils.substring((String)builder.toString(), (int)0, (int)numberOfLetters);
    }

    static {
        StringBuilder builder = new StringBuilder(36);
        for (char number = '0'; number <= '9'; number = (char)(number + '\u0001')) {
            builder.append(number);
        }
        for (char character = 'a'; character <= 'z'; character = (char)(character + '\u0001')) {
            builder.append(character);
        }
        characters = builder.toString().toCharArray();
    }
}

