/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.threetenbp.deser.key;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.threetenbp.deser.key.ThreeTenKeyDeserializer;
import java.io.IOException;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.YearMonth;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.format.DateTimeFormatterBuilder;
import org.threeten.bp.format.SignStyle;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.TemporalField;

public class YearMonthKeyDeserializer
extends ThreeTenKeyDeserializer {
    public static final YearMonthKeyDeserializer INSTANCE = new YearMonthKeyDeserializer();
    private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendValue((TemporalField)ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue((TemporalField)ChronoField.MONTH_OF_YEAR, 2).toFormatter();

    protected YearMonthKeyDeserializer() {
    }

    protected YearMonth deserialize(String key, DeserializationContext ctxt) throws IOException {
        try {
            return YearMonth.parse((CharSequence)key, (DateTimeFormatter)FORMATTER);
        }
        catch (DateTimeException e) {
            return (YearMonth)this._handleDateTimeException(ctxt, YearMonth.class, e, key);
        }
    }
}

