/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.threetenbp.ser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.datatype.threetenbp.function.ToIntFunction;
import com.fasterxml.jackson.datatype.threetenbp.function.ToLongFunction;
import com.fasterxml.jackson.datatype.threetenbp.ser.InstantSerializerBase;
import com.fasterxml.jackson.datatype.threetenbp.ser.ThreeTenFormattedSerializerBase;
import org.threeten.bp.Instant;
import org.threeten.bp.format.DateTimeFormatter;

public class InstantSerializer
extends InstantSerializerBase<Instant> {
    private static final long serialVersionUID = 1L;
    public static final InstantSerializer INSTANCE = new InstantSerializer();

    protected InstantSerializer() {
        super(Instant.class, new ToLongFunction<Instant>(){

            @Override
            public long applyAsLong(Instant instant) {
                return instant.toEpochMilli();
            }
        }, new ToLongFunction<Instant>(){

            @Override
            public long applyAsLong(Instant instant) {
                return instant.getEpochSecond();
            }
        }, new ToIntFunction<Instant>(){

            @Override
            public int applyAsInt(Instant instant) {
                return instant.getNano();
            }
        }, null);
    }

    protected InstantSerializer(InstantSerializer base, Boolean useTimestamp, DateTimeFormatter formatter) {
        this(base, useTimestamp, (Boolean)null, formatter);
    }

    protected InstantSerializer(InstantSerializer base, Boolean useTimestamp, Boolean useNanoseconds, DateTimeFormatter formatter) {
        super(base, useTimestamp, useNanoseconds, formatter);
    }

    @Override
    protected ThreeTenFormattedSerializerBase<Instant> withFormat(Boolean useTimestamp, DateTimeFormatter formatter, JsonFormat.Shape shape) {
        return new InstantSerializer(this, useTimestamp, formatter);
    }

    @Override
    protected ThreeTenFormattedSerializerBase<?> withFeatures(Boolean writeZoneId, Boolean writeNanoseconds) {
        return new InstantSerializer(this, this._useTimestamp, writeNanoseconds, this._formatter);
    }
}

