/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weixin.popular.client.HttpClientFactory;
import weixin.popular.client.JsonResponseHandler;
import weixin.popular.client.LocalResponseHandler;
import weixin.popular.client.ResultErrorHandler;
import weixin.popular.client.XmlResponseHandler;

public class LocalHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(LocalHttpClient.class);
    private static int timeout = 8000;
    private static int retryExecutionCount = 2;
    protected static CloseableHttpClient httpClient = HttpClientFactory.createHttpClient(100, 10, timeout, retryExecutionCount);
    private static Map<String, CloseableHttpClient> httpClient_mchKeyStore = new ConcurrentHashMap<String, CloseableHttpClient>();
    private static ResultErrorHandler resultErrorHandler;
    protected static final Header userAgentHeader;

    public static void setTimeout(int timeout) {
        LocalHttpClient.timeout = timeout;
    }

    public static void setRetryExecutionCount(int retryExecutionCount) {
        LocalHttpClient.retryExecutionCount = retryExecutionCount;
    }

    public static void setResultErrorHandler(ResultErrorHandler resultErrorHandler) {
        LocalHttpClient.resultErrorHandler = resultErrorHandler;
    }

    public static void init(int maxTotal, int maxPerRoute) {
        try {
            httpClient.close();
        }
        catch (IOException e) {
            logger.error("init error", (Throwable)e);
        }
        httpClient = HttpClientFactory.createHttpClient(maxTotal, maxPerRoute, timeout, retryExecutionCount);
    }

    public static void initMchKeyStore(String mch_id, String keyStoreFilePath) {
        try {
            LocalHttpClient.initMchKeyStore(mch_id, new FileInputStream(new File(keyStoreFilePath)));
        }
        catch (FileNotFoundException e) {
            logger.error("init error", (Throwable)e);
        }
    }

    public static void initMchKeyStore(String mch_id, InputStream inputStream) {
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(inputStream, mch_id.toCharArray());
            inputStream.close();
            CloseableHttpClient httpClient = HttpClientFactory.createKeyMaterialHttpClient(keyStore, mch_id, timeout, retryExecutionCount);
            httpClient_mchKeyStore.put(mch_id, httpClient);
        }
        catch (Exception e) {
            logger.error("init mch error", (Throwable)e);
        }
    }

    public static CloseableHttpResponse execute(HttpUriRequest request) {
        LocalHttpClient.loggerRequest(request);
        LocalHttpClient.userAgent(request);
        try {
            return httpClient.execute(request, (HttpContext)HttpClientContext.create());
        }
        catch (Exception e) {
            logger.error("execute error", (Throwable)e);
            return null;
        }
    }

    public static <T> T execute(HttpUriRequest request, ResponseHandler<T> responseHandler) {
        String uriId = LocalHttpClient.loggerRequest(request);
        LocalHttpClient.userAgent(request);
        if (responseHandler instanceof LocalResponseHandler) {
            LocalResponseHandler lrh = (LocalResponseHandler)responseHandler;
            lrh.setUriId(uriId);
        }
        try {
            Object t = httpClient.execute(request, responseHandler, (HttpContext)HttpClientContext.create());
            if (resultErrorHandler != null) {
                resultErrorHandler.doHandle(uriId, request, t);
            }
            return (T)t;
        }
        catch (Exception e) {
            logger.error("execute error", (Throwable)e);
            return null;
        }
    }

    public static <T> T executeJsonResult(HttpUriRequest request, Class<T> clazz) {
        return LocalHttpClient.execute(request, JsonResponseHandler.createResponseHandler(clazz));
    }

    public static <T> T executeXmlResult(HttpUriRequest request, Class<T> clazz) {
        return LocalHttpClient.execute(request, XmlResponseHandler.createResponseHandler(clazz));
    }

    public static <T> T executeXmlResult(HttpUriRequest request, Class<T> clazz, String sign_type, String key) {
        return LocalHttpClient.execute(request, XmlResponseHandler.createResponseHandler(clazz, sign_type, key));
    }

    public static <T> T keyStoreExecuteXmlResult(String mch_id, HttpUriRequest request, Class<T> clazz) {
        return LocalHttpClient.keyStoreExecuteXmlResult(mch_id, request, clazz, null, null);
    }

    public static <T> T keyStoreExecuteXmlResult(String mch_id, HttpUriRequest request, Class<T> clazz, String sign_type, String key) {
        return LocalHttpClient.keyStoreExecute(mch_id, request, XmlResponseHandler.createResponseHandler(clazz, sign_type, key));
    }

    public static <T> T keyStoreExecute(String mch_id, HttpUriRequest request, ResponseHandler<T> responseHandler) {
        String uriId = LocalHttpClient.loggerRequest(request);
        LocalHttpClient.userAgent(request);
        if (responseHandler instanceof LocalResponseHandler) {
            LocalResponseHandler lrh = (LocalResponseHandler)responseHandler;
            lrh.setUriId(uriId);
        }
        try {
            Object t = httpClient_mchKeyStore.get(mch_id).execute(request, responseHandler, (HttpContext)HttpClientContext.create());
            if (resultErrorHandler != null) {
                resultErrorHandler.doHandle(uriId, request, t);
            }
            return (T)t;
        }
        catch (Exception e) {
            logger.error("execute error", (Throwable)e);
            return null;
        }
    }

    private static String loggerRequest(HttpUriRequest request) {
        String id = UUID.randomUUID().toString();
        if (logger.isInfoEnabled() || logger.isDebugEnabled()) {
            if (request instanceof HttpEntityEnclosingRequestBase) {
                HttpEntityEnclosingRequestBase request_base = (HttpEntityEnclosingRequestBase)request;
                HttpEntity entity = request_base.getEntity();
                String content = null;
                if (entity.getContentType().toString().indexOf(ContentType.MULTIPART_FORM_DATA.getMimeType()) == -1) {
                    try {
                        content = EntityUtils.toString((HttpEntity)entity);
                    }
                    catch (Exception e) {
                        logger.error("logger content data get error", (Throwable)e);
                    }
                }
                logger.info("URI[{}] {} {} ContentLength:{} Content:{}", new Object[]{id, request.getURI().toString(), entity.getContentType(), entity.getContentLength(), content == null ? "multipart_form_data" : content});
            } else {
                logger.info("URI[{}] {}", (Object)id, (Object)request.getURI().toString());
            }
        }
        return id;
    }

    private static void userAgent(HttpUriRequest httpUriRequest) {
        httpUriRequest.addHeader(userAgentHeader);
    }

    static {
        userAgentHeader = new BasicHeader("User-Agent", "weixin-popular sdk java v2.8.30");
    }
}

