/*
 * Decompiled with CFR 0.152.
 */
package com.github.rutledgepaulv.qbuilders.structures;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;

public class FieldPath
implements Iterable<FieldNamespace> {
    private List<FieldNamespace> chain = new LinkedList<FieldNamespace>();

    public FieldPath(String raw) {
        this.chain.add(new FieldNamespace(raw));
    }

    public FieldPath(List<FieldNamespace> namespaces) {
        this.chain.addAll(namespaces);
    }

    @Override
    public Iterator<FieldNamespace> iterator() {
        return this.chain.iterator();
    }

    public Stream<FieldNamespace> stream() {
        return FieldPath.streamIter(this);
    }

    public Optional<FieldPath> getParentPath() {
        if (this.chain.size() > 1) {
            return Optional.of(new FieldPath(this.chain.subList(0, this.chain.size() - 1)));
        }
        return Optional.empty();
    }

    public FieldPath append(String ... path) {
        LinkedList<FieldNamespace> chain = new LinkedList<FieldNamespace>();
        chain.addAll(this.chain);
        chain.addAll(Arrays.stream(path).map(x$0 -> new FieldNamespace((String)x$0)).collect(Collectors.toList()));
        return new FieldPath(chain);
    }

    public FieldPath append(FieldPath ... path) {
        LinkedList<FieldNamespace> newChain = new LinkedList<FieldNamespace>();
        newChain.addAll(this.chain);
        newChain.addAll(Arrays.stream(path).flatMap($ -> $.chain.stream()).collect(Collectors.toList()));
        return new FieldPath(newChain);
    }

    public FieldPath prepend(String path) {
        LinkedList<FieldNamespace> chain = new LinkedList<FieldNamespace>();
        chain.add(new FieldNamespace(path));
        chain.addAll(this.chain);
        return new FieldPath(chain);
    }

    public FieldPath prepend(FieldPath path) {
        LinkedList<FieldNamespace> chain = new LinkedList<FieldNamespace>();
        chain.addAll(path.chain);
        chain.addAll(this.chain);
        return new FieldPath(chain);
    }

    public String asFullyQualifiedKey() {
        return this.stream().map(Objects::toString).collect(Collectors.joining("."));
    }

    public String asFullyQualifiedPrefix() {
        return this.stream().map(Objects::toString).collect(Collectors.joining(".", "", "."));
    }

    public String asKey() {
        return this.chain.get(this.chain.size() - 1).toString();
    }

    public String asPrefix() {
        return this.chain.get(this.chain.size() - 1).toString() + ".";
    }

    public String toString() {
        return this.asFullyQualifiedKey();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldPath)) {
            return false;
        }
        FieldPath that = (FieldPath)o;
        return Objects.equals(this.chain, that.chain);
    }

    public int hashCode() {
        return Objects.hash(this.chain);
    }

    private static String strip(String value) {
        return StringUtils.strip((String)value, (String)".");
    }

    private static <T> Stream<T> streamIter(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static class FieldNamespace
    implements Iterable<String> {
        private String raw;

        private FieldNamespace(String raw) {
            this.raw = FieldPath.strip(raw);
        }

        @Override
        public Iterator<String> iterator() {
            return Arrays.stream(StringUtils.split((String)this.raw, (String)".")).iterator();
        }

        public Stream<String> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        public String toString() {
            return this.raw;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldNamespace)) {
                return false;
            }
            FieldNamespace strings = (FieldNamespace)o;
            return Objects.equals(this.raw, strings.raw);
        }

        public int hashCode() {
            return Objects.hash(this.raw);
        }
    }
}

