/*
 * Decompiled with CFR 0.152.
 */
package com.github.rutledgepaulv.qbuilders.visitors;

import com.github.rutledgepaulv.qbuilders.conditions.Condition;
import com.github.rutledgepaulv.qbuilders.nodes.AbstractNode;
import com.github.rutledgepaulv.qbuilders.nodes.AndNode;
import com.github.rutledgepaulv.qbuilders.nodes.ComparisonNode;
import com.github.rutledgepaulv.qbuilders.nodes.LogicalNode;
import com.github.rutledgepaulv.qbuilders.nodes.OrNode;
import com.github.rutledgepaulv.qbuilders.operators.ComparisonOperator;
import java.util.Collection;

public abstract class ContextualNodeVisitor<T, S> {
    protected abstract T visit(AndNode var1, S var2);

    protected abstract T visit(OrNode var1, S var2);

    protected abstract T visit(ComparisonNode var1, S var2);

    protected T condition(ComparisonNode node, S context) {
        if (!node.getOperator().equals(ComparisonOperator.SUB_CONDITION_ANY)) {
            throw new IllegalArgumentException("You can only build a condition for sub-condition operator nodes.");
        }
        Object sub = node.getValues().iterator().next();
        if (sub instanceof AbstractNode) {
            return this.visitAny((AbstractNode)sub, context);
        }
        if (sub instanceof Condition) {
            return (T)((Condition)sub).query(this, context);
        }
        throw new IllegalArgumentException("Unknown node value type for subquery.");
    }

    protected Object single(Collection<?> values) {
        if (!values.isEmpty()) {
            return values.iterator().next();
        }
        throw new IllegalArgumentException("You must provide a non-null query value for the condition.");
    }

    public final T visitAny(AbstractNode node, S context) {
        LogicalNode logical;
        if (node instanceof LogicalNode && (logical = (LogicalNode)node).getChildren().size() == 1) {
            return this.visitAny(logical.getChildren().get(0), context);
        }
        if (node instanceof AndNode) {
            return this.visit((AndNode)node, context);
        }
        if (node instanceof OrNode) {
            return this.visit((OrNode)node, context);
        }
        return this.visit((ComparisonNode)node, context);
    }
}

