/*
 * Decompiled with CFR 0.152.
 */
package com.github.rutledgepaulv.qbuilders.visitors;

import com.github.rutledgepaulv.qbuilders.nodes.AbstractNode;
import com.github.rutledgepaulv.qbuilders.nodes.AndNode;
import com.github.rutledgepaulv.qbuilders.nodes.ComparisonNode;
import com.github.rutledgepaulv.qbuilders.nodes.OrNode;
import com.github.rutledgepaulv.qbuilders.operators.ComparisonOperator;
import com.github.rutledgepaulv.qbuilders.visitors.ContextualNodeVisitor;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class ElasticsearchVisitor
extends ContextualNodeVisitor<QueryBuilder, Context> {
    protected final Function<Object, Object> normalizer;

    public ElasticsearchVisitor() {
        this(Function.identity());
    }

    public ElasticsearchVisitor(Function<Object, Object> normalizer) {
        this.normalizer = normalizer;
    }

    @Override
    protected QueryBuilder visit(AndNode node, Context context) {
        BoolQueryBuilder parent = QueryBuilders.boolQuery();
        node.getChildren().stream().map(child -> (QueryBuilder)this.visitAny((AbstractNode)child, context)).forEach(arg_0 -> ((BoolQueryBuilder)parent).must(arg_0));
        return parent;
    }

    @Override
    protected QueryBuilder visit(OrNode node, Context context) {
        BoolQueryBuilder parent = QueryBuilders.boolQuery();
        node.getChildren().stream().map(child -> (QueryBuilder)this.visitAny((AbstractNode)child, context)).forEach(arg_0 -> ((BoolQueryBuilder)parent).should(arg_0));
        return parent;
    }

    @Override
    protected QueryBuilder visit(ComparisonNode node, Context context) {
        String field;
        ComparisonOperator operator = node.getOperator();
        Collection values = node.getValues().stream().map(this.normalizer).collect(Collectors.toList());
        String string = field = context.originatedAsNestedQuery ? node.getField().asFullyQualifiedKey() : node.getField().asKey();
        if (ComparisonOperator.EQ.equals(operator)) {
            return QueryBuilders.termQuery((String)field, (Object)this.single(values));
        }
        if (ComparisonOperator.NE.equals(operator)) {
            return QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)field, (Object)this.single(values)));
        }
        if (ComparisonOperator.EX.equals(operator)) {
            if (this.single(values).equals(true)) {
                return QueryBuilders.existsQuery((String)field);
            }
            return QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)field));
        }
        if (ComparisonOperator.GT.equals(operator)) {
            return QueryBuilders.rangeQuery((String)field).gt(this.single(values));
        }
        if (ComparisonOperator.LT.equals(operator)) {
            return QueryBuilders.rangeQuery((String)field).lt(this.single(values));
        }
        if (ComparisonOperator.GTE.equals(operator)) {
            return QueryBuilders.rangeQuery((String)field).gte(this.single(values));
        }
        if (ComparisonOperator.LTE.equals(operator)) {
            return QueryBuilders.rangeQuery((String)field).lte(this.single(values));
        }
        if (ComparisonOperator.IN.equals(operator)) {
            return QueryBuilders.termsQuery((String)field, (Collection)values);
        }
        if (ComparisonOperator.NIN.equals(operator)) {
            return QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termsQuery((String)field, (Collection)values));
        }
        if (ComparisonOperator.RE.equals(operator)) {
            return QueryBuilders.regexpQuery((String)field, (String)((String)this.single(values)));
        }
        if (ComparisonOperator.SUB_CONDITION_ANY.equals(operator)) {
            return QueryBuilders.nestedQuery((String)field, (QueryBuilder)((QueryBuilder)this.condition(node, new Context(true))));
        }
        throw new UnsupportedOperationException("This visitor does not support the operator " + operator + ".");
    }

    public static class Context {
        private boolean originatedAsNestedQuery = false;

        public Context() {
        }

        public Context(boolean originatedAsNestedQuery) {
            this.originatedAsNestedQuery = originatedAsNestedQuery;
        }
    }
}

