/*
 * Decompiled with CFR 0.152.
 */
package com.github.rutledgepaulv.qbuilders.visitors;

import com.github.rutledgepaulv.qbuilders.nodes.AndNode;
import com.github.rutledgepaulv.qbuilders.nodes.ComparisonNode;
import com.github.rutledgepaulv.qbuilders.nodes.OrNode;
import com.github.rutledgepaulv.qbuilders.operators.ComparisonOperator;
import com.github.rutledgepaulv.qbuilders.visitors.AbstractVoidContextNodeVisitor;
import java.sql.Date;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.data.mongodb.core.query.Criteria;

public class MongoVisitor
extends AbstractVoidContextNodeVisitor<Criteria> {
    protected final Function<Object, Object> normalizer;

    public MongoVisitor() {
        this(new DefaultNormalizer());
    }

    public MongoVisitor(Function<Object, Object> normalizer) {
        this.normalizer = normalizer;
    }

    @Override
    protected Criteria visit(AndNode node) {
        Criteria criteria = new Criteria();
        List<Criteria> children = node.getChildren().stream().map(this::visitAny).collect(Collectors.toList());
        return criteria.andOperator(children.toArray(new Criteria[children.size()]));
    }

    @Override
    protected Criteria visit(OrNode node) {
        Criteria criteria = new Criteria();
        List<Criteria> children = node.getChildren().stream().map(this::visitAny).collect(Collectors.toList());
        return criteria.orOperator(children.toArray(new Criteria[children.size()]));
    }

    @Override
    protected Criteria visit(ComparisonNode node) {
        ComparisonOperator operator = node.getOperator();
        Collection values = node.getValues().stream().map(this.normalizer).collect(Collectors.toList());
        String field = node.getField().asKey();
        if (ComparisonOperator.EQ.equals(operator)) {
            return Criteria.where((String)field).is(this.single(values));
        }
        if (ComparisonOperator.NE.equals(operator)) {
            return Criteria.where((String)field).ne(this.single(values));
        }
        if (ComparisonOperator.EX.equals(operator)) {
            return Criteria.where((String)field).exists(((Boolean)this.single(values)).booleanValue());
        }
        if (ComparisonOperator.GT.equals(operator)) {
            return Criteria.where((String)field).gt(this.single(values));
        }
        if (ComparisonOperator.LT.equals(operator)) {
            return Criteria.where((String)field).lt(this.single(values));
        }
        if (ComparisonOperator.GTE.equals(operator)) {
            return Criteria.where((String)field).gte(this.single(values));
        }
        if (ComparisonOperator.LTE.equals(operator)) {
            return Criteria.where((String)field).lte(this.single(values));
        }
        if (ComparisonOperator.IN.equals(operator)) {
            return Criteria.where((String)field).in(values);
        }
        if (ComparisonOperator.NIN.equals(operator)) {
            return Criteria.where((String)field).nin(values);
        }
        if (ComparisonOperator.RE.equals(operator)) {
            return Criteria.where((String)field).regex((String)this.single(values));
        }
        if (ComparisonOperator.SUB_CONDITION_ANY.equals(operator)) {
            return Criteria.where((String)field).elemMatch((Criteria)this.condition(node));
        }
        throw new UnsupportedOperationException("This visitor does not support the operator " + operator + ".");
    }

    protected static class DefaultNormalizer
    implements Function<Object, Object> {
        protected DefaultNormalizer() {
        }

        @Override
        public Object apply(Object o) {
            if (o instanceof Instant) {
                return Date.from((Instant)o);
            }
            return o;
        }
    }
}

