/*
 * Decompiled with CFR 0.152.
 */
package com.github.springtestdbunit.dataset;

import com.github.springtestdbunit.dataset.DataSetLoader;
import com.github.springtestdbunit.dataset.FlatXmlDataSetLoader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ReplacementDataSet;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplacementDataSetLoader
implements DataSetLoader {
    public static final Map<String, Object> DEFAULT_OBJECT_REPLACEMENTS = Collections.singletonMap("[null]", null);
    private final DataSetLoader dataSetLoader;
    private final Map<Object, Object> objectReplacements;
    private final Map<String, String> subStringReplacements;

    public ReplacementDataSetLoader() {
        this(new FlatXmlDataSetLoader());
    }

    public ReplacementDataSetLoader(DataSetLoader dataSetLoader) {
        this(dataSetLoader, DEFAULT_OBJECT_REPLACEMENTS);
    }

    public ReplacementDataSetLoader(DataSetLoader dataSetLoader, Map<?, ?> objectReplacements) {
        this(dataSetLoader, objectReplacements, null);
    }

    public ReplacementDataSetLoader(DataSetLoader dataSetLoader, Map<?, ?> objectReplacements, Map<String, String> subStringReplacements) {
        Assert.notNull((Object)dataSetLoader, (String)"Delegate must not be null");
        this.dataSetLoader = dataSetLoader;
        this.objectReplacements = this.unmodifiableMap(objectReplacements);
        this.subStringReplacements = this.unmodifiableMap(subStringReplacements);
    }

    private <K, V> Map<K, V> unmodifiableMap(Map<? extends K, ? extends V> map) {
        LinkedHashMap<? extends K, ? extends V> result = new LinkedHashMap<K, V>();
        if (map != null) {
            result.putAll(map);
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public IDataSet loadDataSet(Class<?> testClass, String location) throws Exception {
        IDataSet dataSet = this.dataSetLoader.loadDataSet(testClass, location);
        ReplacementDataSet replacementDataSet = new ReplacementDataSet(dataSet, this.objectReplacements, this.subStringReplacements);
        return replacementDataSet;
    }
}

