/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.jknack.handlebars.Options;
import com.github.tomakehurst.wiremock.extension.responsetemplating.RenderCache;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.JsonData;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;

public class HandlebarsJsonPathHelper
extends HandlebarsHelper<Object> {
    public Object apply(Object input, Options options) throws IOException {
        if (input == null) {
            return "";
        }
        if (options == null || options.param(0, null) == null) {
            return this.handleError("The JSONPath cannot be empty");
        }
        String jsonPath = (String)options.param(0);
        try {
            DocumentContext jsonDocument = this.getJsonDocument(input, options);
            Object result = this.getValue(jsonPath, jsonDocument, options);
            return JsonData.create(result);
        }
        catch (InvalidJsonException e) {
            return this.handleError(input + " is not valid JSON", e.getJson(), e);
        }
        catch (JsonPathException e) {
            return this.handleError(jsonPath + " is not a valid JSONPath expression", e);
        }
    }

    private Object getValue(String jsonPath, DocumentContext jsonDocument, Options options) {
        RenderCache renderCache = HandlebarsJsonPathHelper.getRenderCache(options);
        RenderCache.Key cacheKey = RenderCache.Key.keyFor(Object.class, jsonPath, jsonDocument);
        Object value = renderCache.get(cacheKey);
        if (value == null) {
            value = jsonDocument.read(jsonPath, new Predicate[0]);
            renderCache.put(cacheKey, value);
        }
        return value;
    }

    private DocumentContext getJsonDocument(Object json, Options options) {
        RenderCache.Key cacheKey;
        RenderCache renderCache = HandlebarsJsonPathHelper.getRenderCache(options);
        DocumentContext document = (DocumentContext)renderCache.get(cacheKey = RenderCache.Key.keyFor(DocumentContext.class, json));
        if (document == null) {
            document = json instanceof String ? JsonPath.parse((String)((String)json)) : JsonPath.parse((Object)json);
            renderCache.put(cacheKey, document);
        }
        return document;
    }
}

