/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty94;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.AbstractHandler;

class ManInTheMiddleSslConnectHandler
extends AbstractHandler {
    private final SslConnectionFactory sslConnectionFactory;

    ManInTheMiddleSslConnectHandler(SslConnectionFactory sslConnectionFactory) {
        this.sslConnectionFactory = sslConnectionFactory;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.sslConnectionFactory.start();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.sslConnectionFactory.stop();
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (HttpMethod.CONNECT.is(request.getMethod())) {
            baseRequest.setHandled(true);
            this.handleConnect(baseRequest, response);
        }
    }

    private void handleConnect(Request baseRequest, HttpServletResponse response) throws IOException {
        this.sendConnectResponse(response);
        HttpChannel httpChannel = baseRequest.getHttpChannel();
        Connector connector = httpChannel.getConnector();
        EndPoint endpoint = httpChannel.getEndPoint();
        endpoint.setConnection(null);
        Connection connection = this.sslConnectionFactory.newConnection(connector, endpoint);
        endpoint.setConnection(connection);
        endpoint.onOpen();
        connection.onOpen();
    }

    private void sendConnectResponse(HttpServletResponse response) throws IOException {
        response.setStatus(200);
        response.getOutputStream().close();
    }
}

