/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.configuration;

import com.github.xiaoymin.knife4j.spring.configuration.Knife4jProperties;
import com.github.xiaoymin.knife4j.spring.filter.ProductionSecurityFilter;
import com.github.xiaoymin.knife4j.spring.filter.SecurityBasicAuthFilter;
import com.github.xiaoymin.knife4j.spring.model.MarkdownFiles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
@EnableConfigurationProperties(value={Knife4jProperties.class})
@ComponentScan(basePackages={"com.github.xiaoymin.knife4j.spring.plugin", "com.github.xiaoymin.knife4j.spring.web"})
public class Knife4jAutoConfiguration {
    @Autowired
    private Environment environment;
    Logger logger = LoggerFactory.getLogger(Knife4jAutoConfiguration.class);

    @Bean(value={"knife4jCorsFilter"})
    @ConditionalOnMissingBean(value={CorsFilter.class})
    @ConditionalOnProperty(name={"knife4j.cors"})
    public CorsFilter corsFilter() {
        this.logger.info("init CorsFilter...");
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.setAllowCredentials(Boolean.valueOf(true));
        corsConfiguration.addAllowedOrigin("*");
        corsConfiguration.addAllowedHeader("*");
        corsConfiguration.addAllowedMethod("*");
        corsConfiguration.setMaxAge(Long.valueOf(10000L));
        source.registerCorsConfiguration("/**", corsConfiguration);
        CorsFilter corsFilter = new CorsFilter((CorsConfigurationSource)source);
        return corsFilter;
    }

    @Bean(initMethod="init")
    public MarkdownFiles markdownFiles(Knife4jProperties knife4jProperties) {
        MarkdownFiles markdownFiles = null;
        markdownFiles = knife4jProperties == null ? new MarkdownFiles(this.environment != null ? this.environment.getProperty("knife4j.markdowns") : "") : new MarkdownFiles(knife4jProperties.getMarkdowns() == null ? "" : knife4jProperties.getMarkdowns());
        return markdownFiles;
    }

    @Bean
    public SecurityBasicAuthFilter securityBasicAuthFilter(Knife4jProperties knife4jProperties) {
        boolean enableSwaggerBasicAuth = false;
        String dftUserName = "admin";
        String dftPass = "123321";
        SecurityBasicAuthFilter securityBasicAuthFilter = null;
        if (knife4jProperties == null) {
            if (this.environment != null) {
                String enableAuth = this.environment.getProperty("knife4j.basic.enable");
                enableSwaggerBasicAuth = Boolean.valueOf(enableAuth);
                if (enableSwaggerBasicAuth) {
                    String pUser = this.environment.getProperty("knife4j.basic.username");
                    String pPass = this.environment.getProperty("knife4j.basic.password");
                    if (pUser != null && !"".equals(pUser)) {
                        dftUserName = pUser;
                    }
                    if (pPass != null && !"".equals(pPass)) {
                        dftPass = pPass;
                    }
                }
                securityBasicAuthFilter = new SecurityBasicAuthFilter(enableSwaggerBasicAuth, dftUserName, dftPass);
            }
        } else {
            securityBasicAuthFilter = knife4jProperties.getBasic() == null ? new SecurityBasicAuthFilter(enableSwaggerBasicAuth, dftUserName, dftPass) : new SecurityBasicAuthFilter(knife4jProperties.getBasic().isEnable(), knife4jProperties.getBasic().getUsername(), knife4jProperties.getBasic().getPassword());
        }
        return securityBasicAuthFilter;
    }

    @Bean
    public ProductionSecurityFilter productionSecurityFilter(Knife4jProperties knife4jProperties) {
        boolean prod = false;
        ProductionSecurityFilter p = null;
        if (knife4jProperties == null) {
            if (this.environment != null) {
                String prodStr = this.environment.getProperty("knife4j.production");
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("swagger.production:{}", (Object)prodStr);
                }
                prod = Boolean.valueOf(prodStr);
            }
            p = new ProductionSecurityFilter(prod);
        } else {
            p = new ProductionSecurityFilter(knife4jProperties.isProduction());
        }
        return p;
    }
}

