/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import org.apache.bcel.classfile.Code;

public class AtomicityProblem
extends OpcodeStackDetector {
    int priority = 5;
    int lastQuestionableCheckTarget = -1;
    private BugReporter bugReporter;
    static final boolean DEBUG = false;

    public AtomicityProblem(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Code obj) {
        this.lastQuestionableCheckTarget = -1;
        super.visit(obj);
    }

    public void sawOpcode(int seen) {
        String methodName;
        OpcodeStack.Item top;
        XMethod m;
        if ((seen == 198 || seen == 199) && (m = (top = this.stack.getStackItem(0)).getReturnValueOf()) != null && m.getClassName().equals("java.util.concurrent.ConcurrentHashMap") && m.getName().equals("get")) {
            this.lastQuestionableCheckTarget = this.getBranchTarget();
            if (seen == 198) {
                this.priority = 3;
            } else if (seen == 199) {
                this.priority = 2;
            }
        }
        if (seen == 182 && this.getDottedClassConstantOperand().equals("java.util.concurrent.ConcurrentHashMap") && (methodName = this.getNameConstantOperand()).equals("put") && this.getPC() < this.lastQuestionableCheckTarget && this.lastQuestionableCheckTarget != -1) {
            this.bugReporter.reportBug(new BugInstance(this, "AT_CONCURRENTHASHMAP_GET_PUT", this.priority).addClassAndMethod(this).addSourceLine(this));
        }
    }
}

