/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.gui2.BugAspects;

public class BugLeafNode {
    private BugInstance bug;

    BugLeafNode(BugInstance b) {
        this.bug = b;
    }

    public BugInstance getBug() {
        return this.bug;
    }

    public String toString() {
        if (this.bug.isDead()) {
            return "\u2620 " + this.bug.getMessageWithoutPrefix();
        }
        return this.bug.getMessageWithoutPrefix();
    }

    public boolean matches(BugAspects.SortableValue keyValuePair) {
        return keyValuePair.key.getFrom(this.bug).equals(keyValuePair.value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BugLeafNode)) {
            return false;
        }
        return this.bug == ((BugLeafNode)o).getBug();
    }

    public int hashCode() {
        return this.bug.hashCode();
    }

    public boolean matches(BugAspects aspects) {
        if (aspects.size() == 0) {
            return true;
        }
        for (BugAspects.SortableValue strPair : aspects) {
            if (this.matches(strPair)) continue;
            return false;
        }
        return true;
    }
}

