/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringEscapeUtils;

public class Strings {
    private static final int xmlAllowedLowCharacterBound = 32;
    private static volatile boolean xmlLowValueEscapeStringsInitialized = false;
    private static final String[] xmlLowValueEscapeStrings = new String[32];
    private static final Object escapeInitLockObject = new Object();
    private static final String unicodeUnescapeMatchExpression = "(\\\\*)(\\\\u)(\\p{XDigit}{4})";
    private static Pattern unescapePattern = null;
    private static volatile boolean paternIsInitialized = false;
    private static final Object unescapeInitLockObject = new Object();

    public static String replace(String source, String find, String repl) {
        return source.replace(find, repl);
    }

    public static String toString(Object[] a) {
        return Arrays.toString(a);
    }

    public static String trimComma(String s) {
        if (s.endsWith(",")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    private static boolean isInvalidXMLCharacter(int c) {
        return c < 32 && c >= 0 && c != 9 && c != 10 && c != 13;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeEscapeMap() {
        if (xmlLowValueEscapeStringsInitialized) {
            return;
        }
        Object object = escapeInitLockObject;
        synchronized (object) {
            if (xmlLowValueEscapeStringsInitialized) {
                return;
            }
            for (int i = 0; i < 32; ++i) {
                String escapedString;
                Strings.xmlLowValueEscapeStrings[i] = Strings.isInvalidXMLCharacter(i) ? (escapedString = String.format("\\u%04x", i)) : null;
            }
            xmlLowValueEscapeStringsInitialized = true;
        }
    }

    public static String escapeXml(String s) {
        Strings.initializeEscapeMap();
        if (s == null || s.length() == 0) {
            return s;
        }
        char[] sChars = s.toCharArray();
        StringBuilder sb = new StringBuilder();
        int lastReplacement = 0;
        for (int i = 0; i < sChars.length; ++i) {
            if (!Strings.isInvalidXMLCharacter(sChars[i])) continue;
            sb.append(sChars, lastReplacement, i - lastReplacement);
            sb.append(xmlLowValueEscapeStrings[sChars[i]]);
            lastReplacement = i + 1;
        }
        if (lastReplacement < sChars.length) {
            sb.append(sChars, lastReplacement, sChars.length - lastReplacement);
        }
        return StringEscapeUtils.escapeXml((String)sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean initializeUnescapePattern() {
        if (paternIsInitialized) {
            return true;
        }
        Object object = unescapeInitLockObject;
        synchronized (object) {
            if (paternIsInitialized) {
                return true;
            }
            try {
                unescapePattern = Pattern.compile(unicodeUnescapeMatchExpression);
            }
            catch (PatternSyntaxException pse) {
                System.err.println("Imposible error:  static final regular expression pattern failed to compile.  Exception:  " + pse.toString());
                return false;
            }
            paternIsInitialized = true;
        }
        return true;
    }

    public static String unescapeXml(String s) {
        Strings.initializeEscapeMap();
        if (!Strings.initializeUnescapePattern()) {
            return s;
        }
        if (s == null || s.length() == 0) {
            return s;
        }
        if (s.contains("\\u")) {
            StringBuffer sUnescaped = new StringBuffer();
            Matcher m = unescapePattern.matcher(s);
            while (m.find()) {
                int escapeCode;
                String slashes = m.group(1);
                String digits = m.group(3);
                try {
                    escapeCode = Integer.parseInt(digits, 16);
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Impossible error: escape sequence '" + digits + "' is not a valid hex number!  " + "Exception: " + nfe.toString());
                    return s;
                }
                if (slashes == null || slashes.length() % 2 != 0 || !Strings.isInvalidXMLCharacter(escapeCode)) continue;
                Character escapedSequence = Character.valueOf((char)escapeCode);
                m.appendReplacement(sUnescaped, slashes + slashes + escapedSequence.toString());
            }
            m.appendTail(sUnescaped);
            s = sUnescaped.toString();
        }
        return StringEscapeUtils.unescapeXml((String)s);
    }
}

