/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine.bcel;

import edu.umd.cs.findbugs.ba.AssertionMethods;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CompactLocationNumbering;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.ReverseDepthFirstSearch;
import edu.umd.cs.findbugs.ba.npe.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.type.ExceptionSetFactory;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.vna.LoadedFieldSet;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.IMethodAnalysisEngine;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.MethodGen;

public abstract class AnalysisFactory<Analysis>
implements IMethodAnalysisEngine<Analysis> {
    private final String analysisName;
    private final Class<Analysis> analysisClass;
    private static final Object NULL_ANALYSIS_RESULT = new Object();

    public AnalysisFactory(String analysisName, Class<Analysis> analysisClass) {
        this.analysisName = analysisName;
        this.analysisClass = analysisClass;
    }

    public String toString() {
        return this.analysisName + " : " + this.analysisClass.getName();
    }

    @Override
    public void registerWith(IAnalysisCache analysisCache) {
        analysisCache.registerMethodAnalysisEngine(this.analysisClass, this);
    }

    protected CFG getCFG(IAnalysisCache analysisCache, MethodDescriptor methodDescriptor) throws CheckedAnalysisException {
        return analysisCache.getMethodAnalysis(CFG.class, methodDescriptor);
    }

    protected DepthFirstSearch getDepthFirstSearch(IAnalysisCache analysisCache, MethodDescriptor methodDescriptor) throws CheckedAnalysisException {
        return analysisCache.getMethodAnalysis(DepthFirstSearch.class, methodDescriptor);
    }

    protected ConstantPoolGen getConstantPoolGen(IAnalysisCache analysisCache, ClassDescriptor classDescriptor) throws CheckedAnalysisException {
        return analysisCache.getClassAnalysis(ConstantPoolGen.class, classDescriptor);
    }

    protected MethodGen getMethodGen(IAnalysisCache analysisCache, MethodDescriptor methodDescriptor) throws CheckedAnalysisException {
        return analysisCache.getMethodAnalysis(MethodGen.class, methodDescriptor);
    }

    protected CompactLocationNumbering getCompactLocationNumbering(IAnalysisCache analysisCache, MethodDescriptor methodDescriptor) throws CheckedAnalysisException {
        return analysisCache.getMethodAnalysis(CompactLocationNumbering.class, methodDescriptor);
    }

    protected ValueNumberDataflow getValueNumberDataflow(IAnalysisCache analysisCache, MethodDescriptor methodDescriptor) throws CheckedAnalysisException {
        return analysisCache.getMethodAnalysis(ValueNumberDataflow.class, methodDescriptor);
    }

    protected AssertionMethods getAssertionMethods(IAnalysisCache analysisCache, ClassDescriptor classDescriptor) throws CheckedAnalysisException {
        return analysisCache.getClassAnalysis(AssertionMethods.class, classDescriptor);
    }

    protected JavaClass getJavaClass(IAnalysisCache analysisCache, ClassDescriptor classDescriptor) throws CheckedAnalysisException {
        return analysisCache.getClassAnalysis(JavaClass.class, classDescriptor);
    }

    protected Method getMethod(IAnalysisCache analysisCache, MethodDescriptor methodDescriptor) throws CheckedAnalysisException {
        return analysisCache.getMethodAnalysis(Method.class, methodDescriptor);
    }

    protected ReverseDepthFirstSearch getReverseDepthFirstSearch(IAnalysisCache analysisCache, MethodDescriptor methodDescriptor) throws CheckedAnalysisException {
        return analysisCache.getMethodAnalysis(ReverseDepthFirstSearch.class, methodDescriptor);
    }

    protected ExceptionSetFactory getExceptionSetFactory(IAnalysisCache analysisCache, MethodDescriptor methodDescriptor) throws CheckedAnalysisException {
        return analysisCache.getMethodAnalysis(ExceptionSetFactory.class, methodDescriptor);
    }

    protected IsNullValueDataflow getIsNullValueDataflow(IAnalysisCache analysisCache, MethodDescriptor methodDescriptor) throws CheckedAnalysisException {
        return analysisCache.getMethodAnalysis(IsNullValueDataflow.class, methodDescriptor);
    }

    protected TypeDataflow getTypeDataflow(IAnalysisCache analysisCache, MethodDescriptor methodDescriptor) throws CheckedAnalysisException {
        return analysisCache.getMethodAnalysis(TypeDataflow.class, methodDescriptor);
    }

    protected LoadedFieldSet getLoadedFieldSet(IAnalysisCache analysisCache, MethodDescriptor methodDescriptor) throws CheckedAnalysisException {
        return analysisCache.getMethodAnalysis(LoadedFieldSet.class, methodDescriptor);
    }
}

