/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui;

import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.SystemProperties;
import java.awt.FlowLayout;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class AnnotatedString {
    private static final boolean MAC_OS_X = SystemProperties.getProperty("os.name").toLowerCase().startsWith("mac os x");
    private final String myAnnotatedString;

    public AnnotatedString(String s) {
        this.myAnnotatedString = s;
    }

    public String toString() {
        if (MAC_OS_X) {
            if (this.myAnnotatedString.matches("[^&]+\\(&\\p{Alnum}\\)")) {
                int endIndex = this.myAnnotatedString.length() - "(&X)".length();
                return this.myAnnotatedString.substring(0, endIndex);
            }
            if (this.myAnnotatedString.matches("[^&]+\\(&\\p{Alnum}\\)\\.\\.\\.")) {
                int startIndex = this.myAnnotatedString.length() - "(&X)...".length();
                int endIndex = startIndex + "(&X)".length();
                return new StringBuilder(this.myAnnotatedString).delete(startIndex, endIndex).toString();
            }
        }
        return this.myAnnotatedString.replaceFirst("&", "");
    }

    public int getMnemonic() {
        int index;
        int mnemonic = 0;
        if (!MAC_OS_X && (index = this.getMnemonicIndex()) >= 0 && index + 1 < this.myAnnotatedString.length()) {
            mnemonic = Character.toUpperCase(this.myAnnotatedString.charAt(index + 1));
        }
        return mnemonic;
    }

    public int getMnemonicIndex() {
        int index = -1;
        if (!MAC_OS_X && (index = this.myAnnotatedString.indexOf(38)) + 1 >= this.myAnnotatedString.length()) {
            index = -1;
        }
        return index;
    }

    private static void addButton(JFrame frame, String s) {
        AnnotatedString as = new AnnotatedString(s);
        JButton button = new JButton(as.toString());
        button.setMnemonic(as.getMnemonic());
        button.setDisplayedMnemonicIndex(as.getMnemonicIndex());
        frame.getContentPane().add(button);
        System.out.println("\"" + s + "\" \"" + as + "\" '" + as.getMnemonic() + "' " + as.getMnemonicIndex());
    }

    public static void main(String[] args) {
        final JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new FlowLayout());
        AnnotatedString.addButton(frame, "&File");
        AnnotatedString.addButton(frame, "S&ave As...");
        AnnotatedString.addButton(frame, "Save &As...");
        AnnotatedString.addButton(frame, "Fo&o");
        AnnotatedString.addButton(frame, "Foo");
        AnnotatedString.addButton(frame, "");
        AnnotatedString.addButton(frame, "&");
        AnnotatedString.addButton(frame, "Foo&");
        AnnotatedString.addButton(frame, "Cat & Dog");
        AnnotatedString.addButton(frame, "Cat && Dog");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    public static void localiseButton(AbstractButton button, String key, String defaultString, boolean setMnemonic) {
        int mnemonic;
        AnnotatedString as = new AnnotatedString(L10N.getLocalString(key, defaultString));
        button.setText(as.toString());
        if (setMnemonic && (mnemonic = as.getMnemonic()) != 0) {
            button.setMnemonic(mnemonic);
            button.setDisplayedMnemonicIndex(as.getMnemonicIndex());
        }
    }
}

