/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.log;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Method;

public class YourKitController {
    private static final boolean ENABLED = SystemProperties.getBoolean("findbugs.yourkit.enabled");
    Object controller;
    Method advanceGeneration;
    Method captureMemorySnapshot;
    Method getStatus;
    public static final long ALLOCATION_RECORDING = 2L;

    public YourKitController() {
        if (!ENABLED) {
            return;
        }
        try {
            Class<?> c = Class.forName("com.yourkit.api.Controller");
            this.controller = c.newInstance();
            this.advanceGeneration = c.getMethod("advanceGeneration", String.class);
            this.captureMemorySnapshot = c.getMethod("captureMemorySnapshot", new Class[0]);
            this.getStatus = c.getMethod("getStatus", new Class[0]);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            this.controller = null;
        }
    }

    public void advanceGeneration(String name) {
        if (this.controller == null) {
            return;
        }
        try {
            this.advanceGeneration.invoke(this.controller, name);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public long getStatus() {
        if (this.getStatus == null) {
            return 0L;
        }
        try {
            return (Long)this.getStatus.invoke(this.controller, new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    @SuppressFBWarnings(value={"DM_GC"})
    public void captureMemorySnapshot() {
        if (this.controller == null) {
            return;
        }
        try {
            System.gc();
            this.captureMemorySnapshot.invoke(this.controller, new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

