/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import java.util.Objects;
import java.util.function.Supplier;

@BugPattern(summary="Prefer InetAddress.getAllName to APIs that convert a hostname to a single IP address", severity=BugPattern.SeverityLevel.WARNING)
public final class AddressSelection
extends BugChecker
implements BugChecker.NewClassTreeMatcher,
BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> CONSTRUCTORS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.constructor().forClass("java.net.Socket").withParameters("java.lang.String", new String[]{"int"}), MethodMatchers.constructor().forClass("java.net.InetSocketAddress").withParameters("java.lang.String", new String[]{"int"})});
    private static final Matcher<ExpressionTree> METHODS = MethodMatchers.staticMethod().onClass("java.net.InetAddress").named("getByName").withParameters("java.lang.String", new String[0]);
    private static final ImmutableSet<String> LOOPBACK = ImmutableSet.of((Object)"127.0.0.1", (Object)"::1");

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (!CONSTRUCTORS.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree argument = tree.getArguments().get(0);
        return this.handleMatch(argument, argument, () -> {
            SuggestedFix.Builder fix = SuggestedFix.builder();
            fix.replace((Tree)argument, SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)"java.net.InetAddress") + ".getLoopbackAddress()");
            return fix.build();
        });
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!METHODS.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree argument = (ExpressionTree)Iterables.getOnlyElement(tree.getArguments());
        return this.handleMatch(argument, tree, () -> SuggestedFix.builder().merge(SuggestedFixes.renameMethodInvocation((MethodInvocationTree)tree, (String)"getLoopbackAddress", (VisitorState)state)).delete((Tree)argument).build());
    }

    private Description handleMatch(ExpressionTree argument, ExpressionTree replacement, Supplier<SuggestedFix> fix) {
        String value = (String)ASTHelpers.constValue((Tree)argument, String.class);
        if (Objects.equals(value, "localhost")) {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(replacement);
        if (LOOPBACK.contains((Object)value)) {
            description.addFix((Fix)fix.get());
        }
        return description.build();
    }
}

