/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject;

import com.google.auto.common.MoreElements;
import com.google.common.collect.ImmutableList;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

public final class ElementPredicates {
    public static boolean isFinalField(Element element) {
        return element.getKind().equals((Object)ElementKind.FIELD) && element.getModifiers().contains((Object)Modifier.FINAL);
    }

    public static boolean isFirstConstructorOfMultiInjectedClass(Element injectedMember) {
        ImmutableList<ExecutableElement> injectConstructors;
        return injectedMember.getKind() == ElementKind.CONSTRUCTOR && (injectConstructors = ElementPredicates.getConstructorsWithAnnotations(injectedMember, Arrays.asList("javax.inject.Inject", "com.google.inject.Inject"))).size() > 1 && ((ExecutableElement)injectConstructors.get(0)).equals(injectedMember);
    }

    public static boolean doesNotHaveRuntimeRetention(Element element) {
        return ElementPredicates.effectiveRetentionPolicy(element) != RetentionPolicy.RUNTIME;
    }

    public static boolean hasSourceRetention(Element element) {
        return ElementPredicates.effectiveRetentionPolicy(element) == RetentionPolicy.SOURCE;
    }

    private static RetentionPolicy effectiveRetentionPolicy(Element element) {
        RetentionPolicy retentionPolicy = RetentionPolicy.CLASS;
        Retention retentionAnnotation = element.getAnnotation(Retention.class);
        if (retentionAnnotation != null) {
            retentionPolicy = retentionAnnotation.value();
        }
        return retentionPolicy;
    }

    private static ImmutableList<ExecutableElement> getConstructorsWithAnnotations(Element exploringConstructor, List<String> annotations) {
        return (ImmutableList)ElementFilter.constructorsIn(exploringConstructor.getEnclosingElement().getEnclosedElements()).stream().filter(constructor -> ElementPredicates.hasAnyOfAnnotation(constructor, annotations)).sorted(Comparator.comparing(e -> e.getSimpleName().toString())).collect(ImmutableList.toImmutableList());
    }

    private static boolean hasAnyOfAnnotation(ExecutableElement input, List<String> annotations) {
        return input.getAnnotationMirrors().stream().map(annotationMirror -> MoreElements.asType((Element)annotationMirror.getAnnotationType().asElement())).anyMatch(type -> ElementPredicates.typeInAnnotations(type, annotations));
    }

    private static boolean typeInAnnotations(TypeElement t, List<String> annotations) {
        return annotations.stream().anyMatch(annotation -> t.getQualifiedName().contentEquals((CharSequence)annotation));
    }

    private ElementPredicates() {
    }
}

