/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.javadoc;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.javadoc.Utils;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneToken;
import com.google.errorprone.util.ErrorProneTokens;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.PackageTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.Context;
import java.util.HashMap;
import javax.lang.model.element.ElementKind;

@BugPattern(summary="Avoid using `/**` for comments which aren't actually Javadoc.", severity=BugPattern.SeverityLevel.WARNING, documentSuppression=false)
public final class NotJavadoc
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        ImmutableMap<Integer, Tree> javadocableTrees = this.getJavadoccableTrees(tree);
        ImmutableRangeSet suppressedRegions = this.suppressedRegions(state);
        for (ErrorProneToken token : ErrorProneTokens.getTokens((String)state.getSourceCode().toString(), (Context)state.context)) {
            for (Tokens.Comment comment : token.comments()) {
                if (!comment.getStyle().equals((Object)Tokens.Comment.CommentStyle.JAVADOC) || comment.getText().equals("/**/") || javadocableTrees.containsKey((Object)token.pos()) || suppressedRegions.intersects(Range.closed((Comparable)Integer.valueOf(comment.getSourcePos(0)), (Comparable)Integer.valueOf(comment.getSourcePos(comment.getText().length() - 1))))) continue;
                int endPos = 2;
                while (comment.getText().charAt(endPos) == '*') {
                    ++endPos;
                }
                state.reportMatch(this.describeMatch(Utils.getDiagnosticPosition(comment.getSourcePos(0), tree), (Fix)SuggestedFix.replace((int)comment.getSourcePos(1), (int)comment.getSourcePos(endPos - 1), (String)"")));
            }
        }
        return Description.NO_MATCH;
    }

    private ImmutableMap<Integer, Tree> getJavadoccableTrees(CompilationUnitTree tree) {
        final HashMap javadoccablePositions = new HashMap();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitPackage(PackageTree packageTree, Void unused) {
                javadoccablePositions.put(ASTHelpers.getStartPosition((Tree)packageTree), packageTree);
                return (Void)super.visitPackage(packageTree, null);
            }

            @Override
            public Void visitClass(ClassTree classTree, Void unused) {
                if (!(ASTHelpers.getSymbol((ClassTree)classTree).owner instanceof Symbol.MethodSymbol)) {
                    javadoccablePositions.put(ASTHelpers.getStartPosition((Tree)classTree), classTree);
                }
                return (Void)super.visitClass(classTree, null);
            }

            @Override
            public Void visitMethod(MethodTree methodTree, Void unused) {
                if (!ASTHelpers.isGeneratedConstructor((MethodTree)methodTree)) {
                    javadoccablePositions.put(ASTHelpers.getStartPosition((Tree)methodTree), methodTree);
                }
                return (Void)super.visitMethod(methodTree, null);
            }

            @Override
            public Void visitVariable(VariableTree variableTree, Void unused) {
                ElementKind kind = ASTHelpers.getSymbol((VariableTree)variableTree).getKind();
                if (kind == ElementKind.FIELD) {
                    javadoccablePositions.put(ASTHelpers.getStartPosition((Tree)variableTree), variableTree);
                }
                if (kind == ElementKind.ENUM_CONSTANT) {
                    javadoccablePositions.put(ASTHelpers.getStartPosition((Tree)variableTree), variableTree);
                    if (variableTree.getInitializer() instanceof NewClassTree) {
                        ClassTree classBody = ((NewClassTree)variableTree.getInitializer()).getClassBody();
                        if (classBody != null) {
                            this.scan(classBody.getMembers(), null);
                        }
                        return null;
                    }
                }
                return (Void)super.visitVariable(variableTree, null);
            }

            @Override
            public Void visitModule(ModuleTree moduleTree, Void unused) {
                javadoccablePositions.put(ASTHelpers.getStartPosition((Tree)moduleTree), moduleTree);
                return (Void)super.visitModule(moduleTree, null);
            }
        }.scan(tree, null);
        return ImmutableMap.copyOf(javadoccablePositions);
    }
}

