/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.util.Util;
import java.util.concurrent.atomic.AtomicReference;

public final class SequenceGroup
extends Sequence {
    private final AtomicReference<Sequence[]> sequencesRef = new AtomicReference<Sequence[]>(new Sequence[0]);

    public SequenceGroup() {
        super(-1L);
    }

    @Override
    public long get() {
        Sequence[] sequences = this.sequencesRef.get();
        return sequences.length != 0 ? Util.getMinimumSequence(sequences) : -1L;
    }

    @Override
    public void set(long value) {
        Sequence[] sequences = this.sequencesRef.get();
        int size = sequences.length;
        for (int i = 0; i < size; ++i) {
            sequences[i].set(value);
        }
    }

    public void add(Sequence sequence) {
        Sequence[] newSequences;
        Sequence[] oldSequences;
        do {
            oldSequences = this.sequencesRef.get();
            int oldSize = oldSequences.length;
            newSequences = new Sequence[oldSize + 1];
            System.arraycopy(oldSequences, 0, newSequences, 0, oldSize);
            newSequences[oldSize] = sequence;
        } while (!this.sequencesRef.compareAndSet(oldSequences, newSequences));
    }

    public boolean remove(Sequence sequence) {
        int numToRemove;
        Sequence[] newSequences;
        Sequence[] oldSequences;
        do {
            boolean found = false;
            oldSequences = this.sequencesRef.get();
            numToRemove = 0;
            for (Sequence oldSequence : oldSequences) {
                if (oldSequence != sequence) continue;
                ++numToRemove;
            }
            if (0 == numToRemove) break;
            int oldSize = oldSequences.length;
            newSequences = new Sequence[oldSize - numToRemove];
            int pos = 0;
            for (int i = 0; i < oldSize; ++i) {
                Sequence testSequence = oldSequences[i];
                if (sequence == testSequence) continue;
                newSequences[pos++] = testSequence;
            }
        } while (!this.sequencesRef.compareAndSet(oldSequences, newSequences));
        return numToRemove != 0;
    }

    public int size() {
        return this.sequencesRef.get().length;
    }
}

