/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.BatchDescriptor;
import com.lmax.disruptor.ClaimStrategy;
import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.ProcessingSequenceBarrier;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.util.Util;

public class Sequencer {
    public static final long INITIAL_CURSOR_VALUE = -1L;
    private final Sequence cursor = new Sequence(-1L);
    private Sequence[] gatingSequences;
    private final ClaimStrategy claimStrategy;
    private final WaitStrategy waitStrategy;

    public Sequencer(ClaimStrategy claimStrategy, WaitStrategy waitStrategy) {
        this.claimStrategy = claimStrategy;
        this.waitStrategy = waitStrategy;
    }

    public void setGatingSequences(Sequence ... sequences) {
        this.gatingSequences = sequences;
    }

    public SequenceBarrier newBarrier(Sequence ... sequencesToTrack) {
        return new ProcessingSequenceBarrier(this.waitStrategy, this.cursor, sequencesToTrack);
    }

    public BatchDescriptor newBatchDescriptor(int size) {
        return new BatchDescriptor(Math.min(size, this.claimStrategy.getBufferSize()));
    }

    public int getBufferSize() {
        return this.claimStrategy.getBufferSize();
    }

    public long getCursor() {
        return this.cursor.get();
    }

    public boolean hasAvailableCapacity(int availableCapacity) {
        return this.claimStrategy.hasAvailableCapacity(availableCapacity, this.gatingSequences);
    }

    public long next() {
        if (null == this.gatingSequences) {
            throw new NullPointerException("gatingSequences must be set before claiming sequences");
        }
        return this.claimStrategy.incrementAndGet(this.gatingSequences);
    }

    public long tryNext(int requiredCapacity) throws InsufficientCapacityException {
        if (null == this.gatingSequences) {
            throw new NullPointerException("gatingSequences must be set before claiming sequences");
        }
        if (requiredCapacity < 1) {
            throw new IllegalArgumentException("Required capacity must be greater than 0");
        }
        return this.claimStrategy.checkAndIncrement(requiredCapacity, 1, this.gatingSequences);
    }

    public BatchDescriptor next(BatchDescriptor batchDescriptor) {
        if (null == this.gatingSequences) {
            throw new NullPointerException("gatingSequences must be set before claiming sequences");
        }
        long sequence = this.claimStrategy.incrementAndGet(batchDescriptor.getSize(), this.gatingSequences);
        batchDescriptor.setEnd(sequence);
        return batchDescriptor;
    }

    public long claim(long sequence) {
        if (null == this.gatingSequences) {
            throw new NullPointerException("gatingSequences must be set before claiming sequences");
        }
        this.claimStrategy.setSequence(sequence, this.gatingSequences);
        return sequence;
    }

    public void publish(long sequence) {
        this.publish(sequence, 1);
    }

    public void publish(BatchDescriptor batchDescriptor) {
        this.publish(batchDescriptor.getEnd(), batchDescriptor.getSize());
    }

    public void forcePublish(long sequence) {
        this.cursor.set(sequence);
        this.waitStrategy.signalAllWhenBlocking();
    }

    private void publish(long sequence, int batchSize) {
        this.claimStrategy.serialisePublishing(sequence, this.cursor, batchSize);
        this.waitStrategy.signalAllWhenBlocking();
    }

    public long remainingCapacity() {
        long consumed = Util.getMinimumSequence(this.gatingSequences);
        long produced = this.cursor.get();
        return (long)this.getBufferSize() - (produced - consumed);
    }
}

