/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.util.Util;
import java.util.concurrent.TimeUnit;

public final class YieldingWaitStrategy
implements WaitStrategy {
    private static final int SPIN_TRIES = 100;

    @Override
    public long waitFor(long sequence, Sequence cursor, Sequence[] dependents, SequenceBarrier barrier) throws AlertException, InterruptedException {
        long availableSequence;
        int counter = 100;
        if (0 == dependents.length) {
            while ((availableSequence = cursor.get()) < sequence) {
                counter = this.applyWaitMethod(barrier, counter);
            }
        } else {
            while ((availableSequence = Util.getMinimumSequence(dependents)) < sequence) {
                counter = this.applyWaitMethod(barrier, counter);
            }
        }
        return availableSequence;
    }

    @Override
    public long waitFor(long sequence, Sequence cursor, Sequence[] dependents, SequenceBarrier barrier, long timeout, TimeUnit sourceUnit) throws AlertException, InterruptedException {
        long availableSequence;
        long timeoutMs = sourceUnit.toMillis(timeout);
        long startTime = System.currentTimeMillis();
        int counter = 100;
        if (0 == dependents.length) {
            while ((availableSequence = cursor.get()) < sequence) {
                counter = this.applyWaitMethod(barrier, counter);
                long elapsedTime = System.currentTimeMillis() - startTime;
                if (elapsedTime <= timeoutMs) continue;
                break;
            }
        } else {
            while ((availableSequence = Util.getMinimumSequence(dependents)) < sequence) {
                counter = this.applyWaitMethod(barrier, counter);
                long elapsedTime = System.currentTimeMillis() - startTime;
                if (elapsedTime <= timeoutMs) continue;
                break;
            }
        }
        return availableSequence;
    }

    @Override
    public void signalAllWhenBlocking() {
    }

    private int applyWaitMethod(SequenceBarrier barrier, int counter) throws AlertException {
        barrier.checkAlert();
        if (0 == counter) {
            Thread.yield();
        } else {
            --counter;
        }
        return counter;
    }
}

