/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.collection;

import ch.lambdaj.Lambda;
import ch.lambdaj.collection.LambdaMap;
import ch.lambdaj.function.aggregate.Aggregator;
import ch.lambdaj.function.convert.Converter;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AbstractLambdaCollection<T> {
    Iterable<? extends T> innerIterable;
    Iterator<? extends T> innerIterator;

    AbstractLambdaCollection(Iterator<? extends T> innerIterator) {
        this.innerIterable = null;
        this.innerIterator = innerIterator;
    }

    AbstractLambdaCollection(Iterable<? extends T> innerIterable) {
        this.innerIterable = innerIterable;
        this.innerIterator = innerIterable.iterator();
    }

    void setInner(Iterable<? extends T> inner) {
        if (inner instanceof Collection && this.innerIterable instanceof Collection) {
            this.setInnerCollection((Collection)inner);
        } else {
            this.innerIterable = inner;
        }
        this.innerIterator = this.innerIterable.iterator();
    }

    private void setInnerCollection(Collection<? extends T> inner) {
        try {
            ((Collection)this.innerIterable).clear();
            ((Collection)this.innerIterable).addAll(inner);
        }
        catch (UnsupportedOperationException e) {
            this.innerIterable = new LinkedList<T>(inner);
        }
    }

    private Object getInner() {
        return this.innerIterable != null ? this.innerIterable : this.innerIterator;
    }

    private Iterator<? extends T> getInnerIterator() {
        return this.innerIterable != null ? this.innerIterable.iterator() : this.innerIterator;
    }

    public T aggregate(Aggregator<T> aggregator) {
        return Lambda.aggregate(this.getInner(), aggregator);
    }

    public <A> A aggregate(A argument, Aggregator<A> aggregator) {
        return Lambda.aggregate(this.getInner(), aggregator, argument);
    }

    public <A> A min(A argument) {
        return Lambda.min(this.getInner(), argument);
    }

    public <A> A max(A argument) {
        return Lambda.max(this.getInner(), argument);
    }

    public <A> A sum(A argument) {
        return Lambda.sum(this.getInner(), argument);
    }

    public <A> T selectMin(A argument) {
        return Lambda.selectMin(this.getInner(), argument);
    }

    public <A> T selectMax(A argument) {
        return Lambda.selectMax(this.getInner(), argument);
    }

    public String join() {
        return Lambda.join(this.getInner());
    }

    public String join(String separator) {
        return Lambda.join(this.getInner(), separator);
    }

    public T forEach() {
        return Lambda.forEach(this.getInnerIterator());
    }

    public T forEach(Matcher<?> matcher) {
        return Lambda.forEach(Lambda.select(this.getInner(), matcher));
    }

    public <K> LambdaMap<K, T> map(Converter<T, K> converter) {
        return new LambdaMap<K, T>(Lambda.map(this.getInner(), converter));
    }

    public <K> LambdaMap<K, T> map(K argument) {
        return new LambdaMap(Lambda.index(this.getInner(), argument));
    }

    public <K> LambdaMap<K, T> map(Matcher<T> matcher, Converter<T, K> converter) {
        return new LambdaMap<K, T>(Lambda.map(this.getInner(), matcher, converter));
    }

    public <K> LambdaMap<K, T> map(Matcher<T> matcher, K argument) {
        return new LambdaMap<K, T>(Lambda.index(this.getInner(), matcher, argument));
    }

    public <A> LambdaMap<A, T> index(A argument) {
        return new LambdaMap(Lambda.index(this.getInner(), argument));
    }

    public boolean exists(Matcher<?> matcher) {
        return this.first(matcher) != null;
    }

    public boolean all(Matcher<?> matcher) {
        Iterator<T> iterator = this.getInnerIterator();
        while (iterator.hasNext()) {
            if (matcher.matches(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public T first(Matcher<?> matcher) {
        return Lambda.selectFirst(this.getInner(), matcher);
    }

    public T unique(Matcher<?> matcher) {
        return Lambda.selectUnique(this.getInner(), matcher);
    }

    public final boolean equals(Object o) {
        return o instanceof AbstractLambdaCollection ? this.getInner().equals(((AbstractLambdaCollection)o).getInner()) : this.getInner().equals(o);
    }

    public final int hashCode() {
        return this.getInner().hashCode();
    }

    public String toString() {
        return this.getInner().toString();
    }
}

