/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.collection;

import ch.lambdaj.Lambda;
import ch.lambdaj.collection.AbstractLambdaCollection;
import ch.lambdaj.collection.LambdaGroup;
import ch.lambdaj.collection.LambdaIterator;
import ch.lambdaj.collection.LambdaSet;
import ch.lambdaj.function.convert.Converter;
import ch.lambdaj.group.GroupCondition;
import ch.lambdaj.util.IntrospectionUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LambdaIterable<T>
extends AbstractLambdaCollection<T>
implements Iterable<T>,
Cloneable,
Serializable {
    LambdaIterable(Iterable<? extends T> inner) {
        super(inner);
    }

    @Override
    public LambdaIterator<T> iterator() {
        return new LambdaIterator(this.innerIterable.iterator());
    }

    public T joinFrom() {
        return Lambda.joinFrom(this.innerIterable);
    }

    public T joinFrom(String separator) {
        return Lambda.joinFrom(this.innerIterable, separator);
    }

    public T sumFrom() {
        return Lambda.sumFrom(this.innerIterable);
    }

    public T maxFrom() {
        return Lambda.maxFrom(this.innerIterable);
    }

    public T minFrom() {
        return Lambda.minFrom(this.innerIterable);
    }

    public LambdaIterable<T> retain(Matcher<?> matcher) {
        this.doRetain(matcher);
        return this;
    }

    void doRetain(Matcher<?> matcher) {
        this.setInner(Lambda.select(this.innerIterable, matcher));
    }

    public LambdaIterable<T> remove(Matcher<?> matcher) {
        this.doRemove(matcher);
        return this;
    }

    void doRemove(Matcher<?> matcher) {
        this.setInner(Lambda.select(this.innerIterable, Matchers.not(matcher)));
    }

    public LambdaIterable<T> sort(Object argument) {
        this.doSort(argument);
        return this;
    }

    void doSort(Object argument) {
        this.setInner(Lambda.sort(this.innerIterable, argument));
    }

    public <V> LambdaIterable<V> convert(Converter<T, V> converter) {
        return new LambdaIterable<V>(this.doConvert(converter));
    }

    <V> List<V> doConvert(Converter<T, V> converter) {
        return Lambda.convert(this.innerIterable, converter);
    }

    public <V> LambdaIterable<V> extract(V argument) {
        return new LambdaIterable<V>(this.doExtract(argument));
    }

    <V> List<V> doExtract(V argument) {
        return Lambda.extract(this.innerIterable, argument);
    }

    public LambdaIterable<T> replace(Matcher<?> matcher, T replacer) {
        this.doReplace(matcher, replacer);
        return this;
    }

    void doReplace(Matcher<?> matcher, T replacer) {
        ArrayList<T> list = new ArrayList<T>();
        for (Object item : this.innerIterable) {
            list.add(matcher.matches(item) ? replacer : item);
        }
        this.setInner(list);
    }

    public LambdaSet<T> distinct() {
        HashSet set = new HashSet();
        for (Object item : this.innerIterable) {
            set.add(item);
        }
        return new LambdaSet(set);
    }

    public LambdaIterable<T> distinct(Object argument) {
        this.doDistinct(argument);
        return this;
    }

    void doDistinct(Object argument) {
        this.setInner(Lambda.selectDistinctArgument(this.innerIterable, argument));
    }

    public <V> LambdaIterable<V> project(Class<V> targetClass, Object ... arguments) {
        return new LambdaIterable<V>(this.doProject(targetClass, arguments));
    }

    <V> List<V> doProject(Class<V> targetClass, Object ... arguments) {
        return Lambda.project((Object)this.innerIterable, targetClass, arguments);
    }

    public LambdaGroup<T> group(GroupCondition<?> ... conditions) {
        return new LambdaGroup(Lambda.group(this.innerIterable, conditions));
    }

    public LambdaIterable<T> clone() {
        return new LambdaIterable(this.innerClone(new ArrayList()));
    }

    Iterable<? extends T> innerClone(Collection<? extends T> emptyInner) {
        try {
            return (Iterable)IntrospectionUtil.clone(this.innerIterable);
        }
        catch (CloneNotSupportedException e) {
            for (Object item : this.innerIterable) {
                emptyInner.add(item);
            }
            return emptyInner;
        }
    }
}

