/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.function.argument;

import ch.lambdaj.function.argument.Argument;
import ch.lambdaj.function.argument.ArgumentConversionException;
import ch.lambdaj.function.argument.InvocationSequence;
import ch.lambdaj.function.argument.ProxyArgument;
import ch.lambdaj.proxy.ProxyUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArgumentsFactory {
    private static final Map<InvocationSequence, Object> PLACEHOLDER_BY_INVOCATION = new WeakHashMap<InvocationSequence, Object>();
    private static final Map<Object, Argument<?>> ARGUMENTS_BY_PLACEHOLDER = new WeakHashMap();
    private static final ThreadLocal<LimitedValuesArgumentHolder> LIMITED_VALUE_ARGUMENTS = new ThreadLocal<LimitedValuesArgumentHolder>(){

        @Override
        protected LimitedValuesArgumentHolder initialValue() {
            return new LimitedValuesArgumentHolder();
        }
    };
    private static final Integer FINAL_PLACEHOLDER_SEED = -1073743798;
    private static final AtomicInteger PLACEHOLDER_COUNTER = new AtomicInteger(Integer.MIN_VALUE);

    private ArgumentsFactory() {
    }

    public static <T> T createArgument(Class<T> clazz) {
        return ArgumentsFactory.createArgument(clazz, new InvocationSequence(clazz));
    }

    static synchronized <T> T createArgument(Class<T> clazz, InvocationSequence invocationSequence) {
        Object placeholder = PLACEHOLDER_BY_INVOCATION.get(invocationSequence);
        if (placeholder == null) {
            placeholder = ArgumentsFactory.registerNewArgument(clazz, invocationSequence);
        } else if (ArgumentsFactory.isLimitedValues(placeholder)) {
            LIMITED_VALUE_ARGUMENTS.get().setArgument(placeholder, new Argument(invocationSequence));
        }
        return (T)placeholder;
    }

    private static <T> T registerNewArgument(Class<T> clazz, InvocationSequence invocationSequence) {
        Object placeholder = ArgumentsFactory.createPlaceholder(clazz, invocationSequence);
        PLACEHOLDER_BY_INVOCATION.put(invocationSequence, placeholder);
        ArgumentsFactory.bindArgument(placeholder, new Argument(invocationSequence));
        return (T)placeholder;
    }

    private static Object createPlaceholder(Class<?> clazz, InvocationSequence invocationSequence) {
        return !Modifier.isFinal(clazz.getModifiers()) ? ProxyUtil.createProxy(new ProxyArgument(clazz, invocationSequence), clazz, false, new Class[0]) : ArgumentsFactory.createArgumentPlaceholder(clazz);
    }

    private static <T> void bindArgument(T placeholder, Argument<T> argument) {
        if (ArgumentsFactory.isLimitedValues(placeholder)) {
            LIMITED_VALUE_ARGUMENTS.get().setArgument(placeholder, argument);
        } else {
            ARGUMENTS_BY_PLACEHOLDER.put(placeholder, argument);
        }
    }

    public static <T> Argument<T> actualArgument(T placeholder) {
        Argument<T> actualArgument = ArgumentsFactory.placeholderToArgument(placeholder);
        if (actualArgument == null) {
            throw new ArgumentConversionException("Unable to convert the placeholder " + placeholder + " in a valid argument");
        }
        return actualArgument;
    }

    private static <T> Argument<T> placeholderToArgument(T placeholder) {
        if (placeholder instanceof Argument) {
            return (Argument)placeholder;
        }
        return ArgumentsFactory.isLimitedValues(placeholder) ? LIMITED_VALUE_ARGUMENTS.get().getArgument(placeholder) : ARGUMENTS_BY_PLACEHOLDER.get(placeholder);
    }

    private static boolean isLimitedValues(Object placeholder) {
        return placeholder != null && ArgumentsFactory.isLimitedValues(placeholder.getClass());
    }

    private static boolean isLimitedValues(Class<?> clazz) {
        return clazz == Boolean.TYPE || clazz == Boolean.class || clazz.isEnum();
    }

    public static <T> T createClosureArgumentPlaceholder(Class<T> clazz) {
        if (clazz == Class.class) {
            return (T)ArgumentsFactory.class;
        }
        return ProxyUtil.isProxable(clazz) ? ArgumentsFactory.createArgument(clazz) : ArgumentsFactory.createFinalArgumentPlaceholder(clazz);
    }

    public static <T> Argument<T> placeholderToClosureArgument(T placeholder) {
        return ArgumentsFactory.placeholderToArgument(placeholder);
    }

    private static <T> T createFinalArgumentPlaceholder(Class<T> clazz) {
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return (T)Boolean.FALSE;
        }
        if (clazz.isEnum()) {
            return (T)EnumSet.allOf(clazz).iterator().next();
        }
        return (T)ArgumentsFactory.createArgumentPlaceholder(clazz, FINAL_PLACEHOLDER_SEED);
    }

    static Object createArgumentPlaceholder(Class<?> clazz) {
        return ArgumentsFactory.isLimitedValues(clazz) ? LIMITED_VALUE_ARGUMENTS.get().getNextPlaceholder(clazz) : ArgumentsFactory.createArgumentPlaceholder(clazz, PLACEHOLDER_COUNTER.addAndGet(1));
    }

    private static Object createArgumentPlaceholder(Class<?> clazz, Integer placeholderId) {
        if (clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || Character.class == clazz) {
            return ArgumentsFactory.getPrimitivePlaceHolder(clazz, placeholderId);
        }
        if (clazz == String.class) {
            return String.valueOf(placeholderId);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return new Date(placeholderId.intValue());
        }
        if (clazz.isArray()) {
            return Array.newInstance(clazz.getComponentType(), 1);
        }
        try {
            return ArgumentsFactory.createArgumentPlaceholderForUnknownClass(clazz, placeholderId);
        }
        catch (Exception e) {
            throw new ArgumentConversionException("It is not possible to create a placeholder for class: " + clazz.getName(), e);
        }
    }

    private static Object createArgumentPlaceholderForUnknownClass(Class<?> clazz, Integer placeholderId) throws IllegalAccessException, InstantiationException {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            Class<?>[] params = constructor.getParameterTypes();
            if (params.length != 1) continue;
            try {
                if (params[0] == String.class) {
                    return constructor.newInstance(String.valueOf(placeholderId));
                }
                if (!ArgumentsFactory.isNumericClass(params[0])) continue;
                return constructor.newInstance(placeholderId);
            }
            catch (IllegalAccessException e1) {
            }
            catch (InvocationTargetException e2) {
                // empty catch block
            }
        }
        return clazz.newInstance();
    }

    private static boolean isNumericClass(Class<?> clazz) {
        return ArgumentsFactory.isInt(clazz) || ArgumentsFactory.isLong(clazz);
    }

    private static Object getPrimitivePlaceHolder(Class<?> clazz, Integer placeholderId) {
        if (ArgumentsFactory.isInt(clazz)) {
            return placeholderId;
        }
        if (ArgumentsFactory.isLong(clazz)) {
            return placeholderId.longValue();
        }
        if (ArgumentsFactory.isDouble(clazz)) {
            return placeholderId.doubleValue();
        }
        if (ArgumentsFactory.isFloat(clazz)) {
            return Float.valueOf(placeholderId.floatValue());
        }
        if (ArgumentsFactory.isCharacter(clazz)) {
            return Character.valueOf(Character.forDigit(placeholderId % 36, 36));
        }
        if (ArgumentsFactory.isShort(clazz)) {
            return placeholderId.shortValue();
        }
        return placeholderId.byteValue();
    }

    private static boolean isInt(Class<?> clazz) {
        return clazz == Integer.TYPE || clazz == Integer.class;
    }

    private static boolean isLong(Class<?> clazz) {
        return clazz == Long.TYPE || clazz == Long.class;
    }

    private static boolean isDouble(Class<?> clazz) {
        return clazz == Double.TYPE || clazz == Double.class;
    }

    private static boolean isFloat(Class<?> clazz) {
        return clazz == Float.TYPE || clazz == Float.class;
    }

    private static boolean isCharacter(Class<?> clazz) {
        return clazz == Character.TYPE || clazz == Character.class;
    }

    private static boolean isShort(Class<?> clazz) {
        return clazz == Short.TYPE || clazz == Short.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LimitedValuesArgumentHolder {
        private boolean booleanPlaceholder = true;
        private final Argument<?>[] booleanArguments = new Argument[2];
        private int enumPlaceholder = 0;
        private final Map<Object, Argument<?>> enumArguments = new HashMap();

        private LimitedValuesArgumentHolder() {
        }

        private int booleanToInt(Object placeholder) {
            return (Boolean)placeholder != false ? 1 : 0;
        }

        void setArgument(Object placeholder, Argument<?> argument) {
            if (placeholder.getClass().isEnum()) {
                this.enumArguments.put(placeholder, argument);
            } else {
                this.booleanArguments[this.booleanToInt((Object)placeholder)] = argument;
            }
        }

        Argument<?> getArgument(Object placeholder) {
            return placeholder.getClass().isEnum() ? this.enumArguments.get(placeholder) : this.booleanArguments[this.booleanToInt(placeholder)];
        }

        Object getNextPlaceholder(Class<?> clazz) {
            return clazz.isEnum() ? this.getNextEnumPlaceholder(clazz) : Boolean.valueOf(this.getNextBooleanPlaceholder());
        }

        private boolean getNextBooleanPlaceholder() {
            this.booleanPlaceholder = !this.booleanPlaceholder;
            return this.booleanPlaceholder;
        }

        private <E extends Enum<E>> Enum<E> getNextEnumPlaceholder(Class<E> clazz) {
            ArrayList<E> enums = new ArrayList<E>(EnumSet.allOf(clazz));
            return (Enum)enums.get(this.enumPlaceholder++ % enums.size());
        }
    }
}

