/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.function.argument;

import ch.lambdaj.function.argument.InvocationException;
import ch.lambdaj.util.IntrospectionUtil;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Invocation {
    private final Class<?> invokedClass;
    private final Method invokedMethod;
    private String invokedPropertyName;
    private ParameterReference[] weakArgs;
    private transient int hashCode;
    Invocation previousInvocation;

    Invocation(Class<?> invokedClass, Method invokedMethod, Object[] args) {
        this.invokedClass = invokedClass;
        this.invokedMethod = invokedMethod;
        invokedMethod.setAccessible(true);
        if (args != null && args.length > 0) {
            this.weakArgs = new ParameterReference[args.length];
            for (int i = 0; i < args.length; ++i) {
                this.weakArgs[i] = invokedMethod.getParameterTypes()[i].isPrimitive() ? new StrongParameterReference(args[i]) : new WeakParameterReference(args[i]);
            }
        }
    }

    private Object[] getConcreteArgs() {
        if (this.weakArgs == null) {
            return new Object[0];
        }
        Object[] args = new Object[this.weakArgs.length];
        for (int i = 0; i < this.weakArgs.length; ++i) {
            args[i] = this.weakArgs[i].get();
        }
        return args;
    }

    Class<?> getInvokedClass() {
        return this.invokedClass;
    }

    Method getInvokedMethod() {
        return this.invokedMethod;
    }

    Class<?> getReturnType() {
        return this.invokedMethod.getReturnType();
    }

    String getInvokedPropertyName() {
        if (this.invokedPropertyName == null) {
            this.invokedPropertyName = IntrospectionUtil.getPropertyName(this.invokedMethod);
        }
        return this.invokedPropertyName;
    }

    Object invokeOn(Object object) throws InvocationException {
        try {
            return object == null ? null : this.invokedMethod.invoke(object, this.getConcreteArgs());
        }
        catch (Exception e) {
            throw new InvocationException(e, this.invokedMethod, object);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.invokedMethod.toString());
        if (this.weakArgs != null) {
            sb.append(" with args ");
            boolean first = true;
            for (ParameterReference arg : this.weakArgs) {
                sb.append(first ? "" : ", ").append(arg.get());
                first = false;
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        this.hashCode = 13 * this.invokedClass.hashCode() + 17 * this.invokedMethod.hashCode();
        if (this.weakArgs != null) {
            this.hashCode += 19 * this.weakArgs.length;
        }
        if (this.previousInvocation != null) {
            this.hashCode += 23 * this.previousInvocation.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        Invocation otherInvocation = (Invocation)object;
        return Invocation.areNullSafeEquals(this.invokedClass, otherInvocation.getInvokedClass()) && Invocation.areNullSafeEquals(this.invokedMethod, otherInvocation.getInvokedMethod()) && Invocation.areNullSafeEquals(this.previousInvocation, otherInvocation.previousInvocation) && Arrays.equals(this.weakArgs, otherInvocation.weakArgs);
    }

    static boolean areNullSafeEquals(Object first, Object second) {
        return first == second || first != null && second != null && first.equals(second);
    }

    private static final class WeakParameterReference
    extends ParameterReference {
        private final WeakReference<Object> weakRef;

        private WeakParameterReference(Object referent) {
            this.weakRef = new WeakReference<Object>(referent);
        }

        protected Object get() {
            return this.weakRef.get();
        }
    }

    private static final class StrongParameterReference
    extends ParameterReference {
        private final Object strongRef;

        private StrongParameterReference(Object referent) {
            this.strongRef = referent;
        }

        protected Object get() {
            return this.strongRef;
        }
    }

    private static abstract class ParameterReference {
        private ParameterReference() {
        }

        protected abstract Object get();

        public final boolean equals(Object obj) {
            return obj instanceof ParameterReference && Invocation.areNullSafeEquals(this.get(), ((ParameterReference)obj).get());
        }
    }
}

