/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.function.argument;

import ch.lambdaj.function.argument.Invocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InvocationSequence {
    private static final long serialVersionUID = 1L;
    private final Class<?> rootInvokedClass;
    private String inkvokedPropertyName;
    private Invocation lastInvocation;
    private transient int hashCode;

    InvocationSequence(Class<?> rootInvokedClass) {
        this.rootInvokedClass = rootInvokedClass;
    }

    InvocationSequence(InvocationSequence sequence, Invocation invocation) {
        this(sequence.getRootInvokedClass());
        invocation.previousInvocation = sequence.lastInvocation;
        this.lastInvocation = invocation;
    }

    Class<?> getRootInvokedClass() {
        return this.rootInvokedClass;
    }

    String getInkvokedPropertyName() {
        if (this.inkvokedPropertyName == null) {
            this.inkvokedPropertyName = this.calcInkvokedPropertyName();
        }
        return this.inkvokedPropertyName;
    }

    private String calcInkvokedPropertyName() {
        if (null == this.lastInvocation) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.calcInkvokedPropertyName(this.lastInvocation, this.lastInvocation.previousInvocation, sb);
        return sb.substring(1);
    }

    private void calcInkvokedPropertyName(Invocation inv, Invocation prevInv, StringBuilder sb) {
        if (prevInv != null) {
            this.calcInkvokedPropertyName(prevInv, prevInv.previousInvocation, sb);
        }
        sb.append(".").append(inv.getInvokedPropertyName());
    }

    Class<?> getReturnType() {
        return this.lastInvocation.getReturnType();
    }

    public boolean equals(Object object) {
        return object != null && this.rootInvokedClass == ((InvocationSequence)object).rootInvokedClass && Invocation.areNullSafeEquals(this.lastInvocation, ((InvocationSequence)object).lastInvocation);
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        this.hashCode = 13 * this.rootInvokedClass.hashCode();
        int factor = 17;
        Invocation invocation = this.lastInvocation;
        while (invocation != null) {
            this.hashCode += factor * invocation.hashCode();
            factor += 2;
            invocation = invocation.previousInvocation;
        }
        return this.hashCode;
    }

    public <T> T invokeOn(Object object) {
        return (T)this.invokeOn(this.lastInvocation, object);
    }

    private Object invokeOn(Invocation invocation, Object value) {
        if (invocation == null) {
            return value;
        }
        if (invocation.previousInvocation != null) {
            value = this.invokeOn(invocation.previousInvocation, value);
        }
        return invocation.invokeOn(value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("[");
        if (this.lastInvocation == null) {
            sb.append(this.rootInvokedClass);
        } else {
            this.toString(this.lastInvocation, this.lastInvocation.previousInvocation, sb, true);
        }
        sb.append("]");
        return sb.toString();
    }

    private void toString(Invocation inv, Invocation prevInv, StringBuilder sb, boolean first) {
        if (prevInv != null) {
            this.toString(prevInv, prevInv.previousInvocation, sb, false);
        }
        sb.append(inv);
        if (!first) {
            sb.append(", ");
        }
    }
}

