/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.function.closure;

import ch.lambdaj.function.closure.ClosuresFactory;
import ch.lambdaj.function.closure.Invokable;
import ch.lambdaj.function.closure.InvokableConstructor;
import ch.lambdaj.function.closure.InvokableMethod;
import ch.lambdaj.function.closure.WrongClosureInvocationException;
import ch.lambdaj.util.IntrospectionUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractClosure {
    public static final String CONSTRUCTOR = "<init>";
    private Object closed;
    private List<Invokable> invokables = new ArrayList<Invokable>();
    private List<Object[]> argsList = new ArrayList<Object[]>();
    private Object[] curriedVars;
    private boolean[] curriedVarsFlags;
    private int freeVarsNumber = 0;
    private final List<Object[]> unhandeledInvocations = new ArrayList<Object[]>();

    AbstractClosure() {
    }

    public <T> T of(Class<T> closedClass) {
        return this.of(closedClass, closedClass);
    }

    public <T> T of(T closed) {
        return (T)this.of(closed, closed.getClass());
    }

    public <T> T of(Object closed, Class<T> closedClass) {
        this.setClosed(closed);
        return ClosuresFactory.createProxyClosure(this, closedClass);
    }

    protected AbstractClosure of(Object closedObject, String methodName, Object ... args) {
        Class<?> closedClass = closedObject instanceof Class ? (Class<?>)closedObject : closedObject.getClass();
        Invokable invokable = methodName.equals(CONSTRUCTOR) ? new InvokableConstructor(IntrospectionUtil.findConstructor(closedClass, args)) : new InvokableMethod(IntrospectionUtil.findMethod(closedClass, methodName, args));
        this.bindInvocation(invokable, args);
        this.setClosed(invokable.isStatic() ? null : closedObject);
        return this;
    }

    public int getFreeVarsNumber() {
        return this.freeVarsNumber;
    }

    public <T> T cast(Class<T> asInterface) throws IllegalArgumentException {
        if (!asInterface.isInterface()) {
            throw new IllegalArgumentException("Cannot cast a closure to the concrete class " + asInterface.getName());
        }
        Method[] methods = asInterface.getMethods();
        if (methods.length != 1) {
            throw new IllegalArgumentException("Cannot cast a closure to an interface with more than one method");
        }
        return (T)Proxy.newProxyInstance(asInterface.getClassLoader(), new Class[]{asInterface}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws WrongClosureInvocationException {
                return AbstractClosure.this.closeOne(args);
            }
        });
    }

    void setClosed(Object closed) {
        this.closed = closed;
        if (this.isClosedOnFreeVar()) {
            ++this.freeVarsNumber;
        }
    }

    private boolean isClosedOnFreeVar() {
        return this.closed instanceof Class;
    }

    void bindInvocation(Method method, Object[] args) {
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        this.bindInvocation(new InvokableMethod(method), args);
    }

    private void bindInvocation(Invokable invokable, Object[] args) {
        this.invokables.add(invokable);
        if (args != null) {
            for (Object arg : args) {
                if (!ClosuresFactory.getClosureVarType(arg).isClosureVarPlaceholder()) continue;
                ++this.freeVarsNumber;
            }
        }
        this.argsList.add(args);
    }

    void closeUnhandledInvocations() {
        for (Object[] vars : this.unhandeledInvocations) {
            this.closeOne(vars);
        }
        this.unhandeledInvocations.clear();
    }

    Object closeOne(Object ... vars) throws WrongClosureInvocationException {
        if (this.invokables.isEmpty()) {
            this.unhandeledInvocations.add(vars);
            return null;
        }
        List<Object[]> boundParams = this.bindParams(vars);
        Object result = this.isClosedOnFreeVar() ? vars[0] : this.closed;
        Iterator<Object[]> argsIterator = boundParams != null ? boundParams.iterator() : null;
        for (Invokable invokable : this.invokables) {
            result = invokable.invoke(result, argsIterator != null ? argsIterator.next() : null);
        }
        return result;
    }

    List<?> closeAll(Object ... vars) throws WrongClosureInvocationException {
        ArrayList<Object> results = new ArrayList<Object>();
        for (Object var : vars) {
            results.add(this.closeOne(var));
        }
        return results;
    }

    List<?> closeAll(Iterable<?> ... vars) throws WrongClosureInvocationException {
        Object[] varSet;
        ArrayList<Object> results = new ArrayList<Object>();
        int length = vars.length;
        Iterator[] iterators = new Iterator[length];
        for (int i = 0; i < length; ++i) {
            iterators[i] = vars[i].iterator();
        }
        while (!this.buildParams(length, iterators, varSet = new Object[length])) {
            results.add(this.closeOne(varSet));
        }
        return results;
    }

    private boolean buildParams(int length, Iterator<?>[] iterators, Object[] varSet) {
        for (int i = 0; i < length; ++i) {
            if (!iterators[i].hasNext()) {
                return true;
            }
            varSet[i] = iterators[i].next();
        }
        return false;
    }

    private List<Object[]> bindParams(Object ... vars) throws WrongClosureInvocationException {
        if (this.checkParams(vars)) {
            return null;
        }
        int varCounter = this.isClosedOnFreeVar() ? 1 : 0;
        int curriedParamCounter = 0;
        ArrayList<Object[]> boundParams = new ArrayList<Object[]>();
        for (Object[] args : this.argsList) {
            if (args == null) {
                boundParams.add(null);
                continue;
            }
            Object[] objs = new Object[args.length];
            block6: for (int i = 0; i < args.length; ++i) {
                switch (ClosuresFactory.getClosureVarType(args[i])) {
                    case VAR: {
                        objs[i] = this.curriedVars != null && this.curriedVarsFlags[curriedParamCounter] ? this.curriedVars[curriedParamCounter] : ClosuresFactory.getClosureVarArgument(args[i]).evaluate(vars[varCounter++]);
                        ++curriedParamCounter;
                        continue block6;
                    }
                    case FINAL_VAR: {
                        objs[i] = this.curriedVars != null && this.curriedVarsFlags[curriedParamCounter] ? this.curriedVars[curriedParamCounter] : vars[varCounter++];
                        ++curriedParamCounter;
                        continue block6;
                    }
                    case FIXED: {
                        objs[i] = args[i];
                    }
                }
            }
            boundParams.add(objs);
        }
        return boundParams;
    }

    private boolean checkParams(Object ... vars) {
        if (vars == null || vars.length == 0) {
            if (this.freeVarsNumber != 0) {
                throw new WrongClosureInvocationException("Closure invoked without vars instead of the expected " + this.freeVarsNumber);
            }
            if (this.curriedVars == null && this.argsList == null) {
                return true;
            }
        }
        if (this.freeVarsNumber != vars.length) {
            throw new WrongClosureInvocationException("Closure invoked with " + vars.length + " vars instead of the expected " + this.freeVarsNumber);
        }
        if (this.isClosedOnFreeVar()) {
            this.checkClosedType(vars[0]);
        }
        return false;
    }

    private void checkClosedType(Object toBeClosed) {
        if (!((Class)this.closed).isInstance(toBeClosed)) {
            throw new WrongClosureInvocationException("The first var must be of class " + this.closed);
        }
    }

    <T extends AbstractClosure> T curry(T curriedClosure, Object curried, int position) throws IllegalArgumentException {
        this.cloneClosureForCurry(curriedClosure);
        super.curryParam(curried, position);
        return curriedClosure;
    }

    private <T extends AbstractClosure> void cloneClosureForCurry(T curriedClosure) {
        curriedClosure.closed = this.closed;
        curriedClosure.invokables = this.invokables;
        curriedClosure.argsList = this.argsList;
        curriedClosure.freeVarsNumber = this.freeVarsNumber;
        if (this.curriedVars != null) {
            curriedClosure.curriedVars = new Object[this.curriedVars.length];
            System.arraycopy(this.curriedVars, 0, curriedClosure.curriedVars, 0, this.curriedVars.length);
        }
        if (this.curriedVarsFlags != null) {
            curriedClosure.curriedVarsFlags = new boolean[this.curriedVarsFlags.length];
            System.arraycopy(this.curriedVarsFlags, 0, curriedClosure.curriedVarsFlags, 0, this.curriedVarsFlags.length);
        }
    }

    private void curryParam(Object curried, int position) throws IllegalArgumentException {
        if (this.checkCurriedOnClosed(curried, position)) {
            return;
        }
        if (this.curriedVars == null) {
            this.curriedVars = new Object[this.freeVarsNumber];
            this.curriedVarsFlags = new boolean[this.freeVarsNumber];
        }
        if (!this.findVarToBeCurried(curried, position)) {
            throw new IllegalArgumentException("Trying to curry this closure on an already bound or unexisting variable");
        }
    }

    private boolean checkCurriedOnClosed(Object curried, int position) {
        if (position != 1 || !this.isClosedOnFreeVar()) {
            return false;
        }
        this.checkClosedType(curried);
        this.closed = curried;
        --this.freeVarsNumber;
        return true;
    }

    private boolean findVarToBeCurried(Object curried, int position) {
        int counter = position;
        for (int i = 0; i < this.curriedVars.length; ++i) {
            if (this.curriedVarsFlags[i] || --counter != 0) continue;
            this.curriedVars[i] = curried;
            this.curriedVarsFlags[i] = true;
            --this.freeVarsNumber;
            return true;
        }
        return false;
    }
}

