/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.group;

import ch.lambdaj.group.GroupComparator;
import ch.lambdaj.group.GroupItem;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GroupCondition<T> {
    protected final Map<String, T> additionalProperties = new TreeMap<String, T>();
    private String alias;
    private GroupComparator<? extends Comparable> groupComparator;

    protected abstract String getGroupName();

    protected abstract Object getGroupValue(Object var1);

    protected String getAlias() {
        return this.alias;
    }

    public GroupCondition as(String alias) {
        this.alias = alias;
        return this;
    }

    protected Collection<String> getAdditionalPropertyNames() {
        return this.additionalProperties.keySet();
    }

    protected abstract String getAdditionalPropertyValue(String var1, Object var2);

    <I> GroupItem<I> create(I item, Object key, String keyAsString) {
        GroupItem groupItem = new GroupItem(key, this.getAlias());
        groupItem.put(this.getGroupName(), keyAsString);
        for (String propertyName : this.getAdditionalPropertyNames()) {
            groupItem.put(propertyName, this.getAdditionalPropertyValue(propertyName, item));
        }
        return groupItem;
    }

    protected String asNotNullString(Object key) {
        return key == null ? "" : key.toString();
    }

    public <A extends Comparable<A>> GroupCondition sort(A sortingArgument) {
        this.groupComparator = new GroupComparator<A>(sortingArgument);
        return this;
    }

    <G> void sortGroup(List<GroupItem<G>> group) {
        if (this.groupComparator != null) {
            Collections.sort(group, this.groupComparator);
        }
    }
}

