/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.group;

import ch.lambdaj.group.Group;
import ch.lambdaj.group.GroupCondition;
import ch.lambdaj.group.GroupItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GroupImpl<T>
extends LinkedList<GroupItem<T>>
implements Group<T> {
    private static final long serialVersionUID = 1L;
    private final Map<String, GroupItem<T>> groupsMap = new HashMap<String, GroupItem<T>>();
    private final GroupCondition<?> groupCondition;
    private Object key;

    GroupImpl(GroupCondition<?> groupCondition) {
        this.groupCondition = groupCondition;
    }

    void addItem(T item) {
        GroupItem<T> groupItem = this.findOrCreate(item, this.groupCondition.getGroupValue(item));
        groupItem.addChild(item);
    }

    private GroupItem<T> findOrCreate(T item, Object key) {
        String keyAsString = key == null ? "" : key.toString();
        GroupItem<T> groupItem = this.groupsMap.get(keyAsString);
        return groupItem != null ? groupItem : this.create(item, key, keyAsString);
    }

    private GroupItem<T> create(T item, Object key, String keyAsString) {
        GroupItem<T> groupItem = this.groupCondition.create(item, key, keyAsString);
        this.groupsMap.put(keyAsString, groupItem);
        this.add(groupItem);
        return groupItem;
    }

    @Override
    public Object key() {
        return this.key;
    }

    void setKey(Object key) {
        this.key = key;
    }

    @Override
    public Set<String> keySet() {
        return this.groupsMap.keySet();
    }

    @Override
    public Group<T> findGroup(String key) {
        GroupItem<T> groupItem = this.groupsMap.get(key);
        return groupItem == null ? null : groupItem.asGroup();
    }

    @Override
    public Group<T> findGroup(Object key) {
        return this.findGroup(key.toString());
    }

    @Override
    public List<Group<T>> subgroups() {
        LinkedList<Group<T>> resultList = new LinkedList<Group<T>>();
        for (GroupItem groupItem : this) {
            resultList.add(groupItem.asGroup());
        }
        return resultList;
    }

    @Override
    public List<T> find(String key) {
        GroupItem<T> groupItem = this.groupsMap.get(key);
        return groupItem == null ? new LinkedList() : groupItem.asList();
    }

    @Override
    public List<T> find(Object key) {
        return this.find(key.toString());
    }

    @Override
    public List<T> findAll() {
        LinkedList allItems = new LinkedList();
        for (GroupItem groupItem : this) {
            allItems.addAll(groupItem.asList());
        }
        return allItems;
    }

    @Override
    public T first() {
        return ((GroupItem)this.get(0)).asList().get(0);
    }

    @Override
    public int getSize() {
        return this.findAll().size();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public Set<String> getHeads() {
        return new HashSet<String>();
    }

    @Override
    public String getHeadValue(String key) {
        return "";
    }
}

