/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.group;

import ch.lambdaj.group.Group;
import ch.lambdaj.group.GroupImpl;
import ch.lambdaj.group.LeafGroup;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupItem<T>
extends TreeMap<String, Object>
implements Iterable<T> {
    private static final long serialVersionUID = 1L;
    private static final String CHILDREN_NODE = "children";
    private String childrenNodeName = "children";
    private boolean leaf = true;
    private final Object groupKey;

    GroupItem() {
        this.groupKey = null;
    }

    GroupItem(Object groupKey, String childrenNodeName) {
        this.groupKey = groupKey;
        if (childrenNodeName != null) {
            this.childrenNodeName = childrenNodeName;
        }
    }

    Object getGroupKey() {
        return this.groupKey;
    }

    private String getChildrenNodeName() {
        return this.childrenNodeName;
    }

    private List<T> getChildren() {
        LinkedList children = (LinkedList)this.get(this.getChildrenNodeName());
        if (children == null) {
            children = new LinkedList();
            this.put(this.getChildrenNodeName(), children);
        }
        return children;
    }

    public Group<T> asGroup() {
        return this.leaf ? new LeafGroup(this, this.getChildrenNodeName()) : (Group)this.get(this.getChildrenNodeName());
    }

    @Override
    public Iterator<T> iterator() {
        return this.asList().iterator();
    }

    List<T> asList() {
        if (this.leaf) {
            return this.getChildren();
        }
        LinkedList<T> leafs = new LinkedList<T>();
        for (T item : this.asGroup().findAll()) {
            leafs.add(item);
        }
        return leafs;
    }

    void addChild(T child) {
        if (!this.leaf) {
            throw new IllegalStateException("cannot add a child to a non-leaf group");
        }
        this.getChildren().add(child);
    }

    void setChildren(GroupImpl<T> children) {
        this.leaf = false;
        children.setKey(this.getGroupKey());
        this.put(this.getChildrenNodeName(), children);
    }
}

