/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.proxy;

import ch.lambdaj.proxy.ClassImposterizer;
import ch.lambdaj.proxy.InvocationInterceptor;
import ch.lambdaj.proxy.ProxyIterator;
import ch.lambdaj.proxy.UnproxableClassException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProxyUtil {
    private ProxyUtil() {
    }

    public static boolean isProxable(Class<?> clazz) {
        return !clazz.isPrimitive() && !Modifier.isFinal(clazz.getModifiers()) && !clazz.isAnonymousClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T createProxy(InvocationInterceptor interceptor, Class<T> clazz, boolean failSafe, Class<?> ... implementedInterface) {
        if (clazz.isInterface()) {
            return (T)ProxyUtil.createNativeJavaProxy(clazz.getClassLoader(), interceptor, ProxyUtil.concatClasses(new Class[]{clazz}, implementedInterface));
        }
        ProxyIterator proxyIterator = interceptor instanceof ProxyIterator ? (ProxyIterator)interceptor : null;
        try {
            if (proxyIterator != null) {
                proxyIterator.enabled = false;
            }
            Object object = ProxyUtil.createEnhancer(interceptor, clazz, implementedInterface).create();
            return (T)object;
        }
        catch (IllegalArgumentException iae) {
            if (Proxy.isProxyClass(clazz)) {
                Object object = ProxyUtil.createNativeJavaProxy(clazz.getClassLoader(), interceptor, ProxyUtil.concatClasses(implementedInterface, clazz.getInterfaces()));
                return (T)object;
            }
            if (ProxyUtil.isProxable(clazz)) {
                T t = ClassImposterizer.INSTANCE.imposterise((Callback)interceptor, clazz, implementedInterface);
                return t;
            }
            T t = ProxyUtil.manageUnproxableClass(clazz, failSafe);
            return t;
        }
        finally {
            if (proxyIterator != null) {
                proxyIterator.enabled = true;
            }
        }
    }

    private static <T> T manageUnproxableClass(Class<T> clazz, boolean failSafe) {
        if (failSafe) {
            return null;
        }
        throw new UnproxableClassException(clazz);
    }

    public static <T> T createIterableProxy(InvocationInterceptor interceptor, Class<T> clazz) {
        if (clazz.isPrimitive()) {
            return null;
        }
        return ProxyUtil.createProxy(interceptor, ProxyUtil.normalizeProxiedClass(clazz), false, Iterable.class);
    }

    private static <T> Class<T> normalizeProxiedClass(Class<T> clazz) {
        if (clazz == String.class) {
            return CharSequence.class;
        }
        return clazz;
    }

    private static Enhancer createEnhancer(MethodInterceptor interceptor, Class<?> clazz, Class<?> ... interfaces) {
        Enhancer enhancer = new Enhancer();
        enhancer.setCallback((Callback)interceptor);
        enhancer.setSuperclass(clazz);
        if (interfaces != null && interfaces.length > 0) {
            enhancer.setInterfaces((Class[])interfaces);
        }
        return enhancer;
    }

    private static Object createNativeJavaProxy(ClassLoader classLoader, InvocationHandler interceptor, Class<?> ... interfaces) {
        return Proxy.newProxyInstance(classLoader, interfaces, interceptor);
    }

    private static Class<?>[] concatClasses(Class<?>[] first, Class<?>[] second) {
        if (first == null || first.length == 0) {
            return second;
        }
        if (second == null || second.length == 0) {
            return first;
        }
        Class[] concatClasses = new Class[first.length + second.length];
        System.arraycopy(first, 0, concatClasses, 0, first.length);
        System.arraycopy(second, 0, concatClasses, first.length, second.length);
        return concatClasses;
    }
}

