/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.util;

import ch.lambdaj.util.IntrospectionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntrospectionUtil {
    private IntrospectionUtil() {
    }

    public static String getPropertyName(Method invokedMethod) {
        String methodName = invokedMethod.getName();
        if ((methodName.startsWith("get") || methodName.startsWith("set")) && methodName.length() > 3) {
            methodName = methodName.substring(3);
        } else if (methodName.startsWith("is") && methodName.length() > 2) {
            methodName = methodName.substring(2);
        }
        return methodName.substring(0, 1).toLowerCase(Locale.getDefault()) + methodName.substring(1);
    }

    public static Object getPropertyValue(Object bean, String propertyName) {
        if (bean == null) {
            return null;
        }
        int dotPos = propertyName.indexOf(46);
        if (dotPos > 0) {
            return IntrospectionUtil.getPropertyValue(IntrospectionUtil.getPropertyValue(bean, propertyName.substring(0, dotPos)), propertyName.substring(dotPos + 1));
        }
        String accessorName = propertyName.substring(0, 1).toUpperCase(Locale.getDefault()) + propertyName.substring(1);
        try {
            return bean.getClass().getMethod("get" + accessorName, new Class[0]).invoke(bean, (Object[])null);
        }
        catch (Exception e) {
            return IntrospectionUtil.getBooleanPropertyValue(bean, propertyName, accessorName);
        }
    }

    private static Object getBooleanPropertyValue(Object bean, String propertyName, String accessorName) {
        try {
            return bean.getClass().getMethod("is" + accessorName, new Class[0]).invoke(bean, (Object[])null);
        }
        catch (Exception e) {
            return IntrospectionUtil.getPlainPropertyValue(bean, propertyName);
        }
    }

    private static Object getPlainPropertyValue(Object bean, String propertyName) {
        try {
            return bean.getClass().getMethod(propertyName, new Class[0]).invoke(bean, (Object[])null);
        }
        catch (Exception e) {
            throw new IntrospectionException(e);
        }
    }

    public static <T> Constructor<T> findConstructor(Class<T> clazz, Object ... args) {
        return IntrospectionUtil.findConstructor(clazz, IntrospectionUtil.objectsToClasses(args));
    }

    public static <T> Constructor<T> findConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        try {
            return clazz.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            Constructor<T> constructor = IntrospectionUtil.discoverConstructor(clazz, parameterTypes);
            if (constructor == null) {
                throw new IntrospectionException(e);
            }
            return constructor;
        }
    }

    private static <T> Constructor<T> discoverConstructor(Class<?> clazz, Class<?> ... parameterTypes) {
        for (Constructor<?> c : clazz.getConstructors()) {
            if (!IntrospectionUtil.areCompatible(c.getParameterTypes(), parameterTypes)) continue;
            return c;
        }
        return null;
    }

    public static Method findMethod(Class<?> clazz, String methodName, Object ... args) {
        return IntrospectionUtil.findMethod(clazz, methodName, IntrospectionUtil.objectsToClasses(args));
    }

    public static Method findMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            Method method = IntrospectionUtil.discoverMethod(clazz, methodName, parameterTypes);
            if (method == null) {
                throw new IntrospectionException(e);
            }
            return method;
        }
    }

    private static Method discoverMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        for (Method m : clazz.getMethods()) {
            if (!m.getName().equals(methodName) || !IntrospectionUtil.areCompatible(m.getParameterTypes(), parameterTypes)) continue;
            return m;
        }
        return null;
    }

    private static boolean areCompatible(Class<?>[] methodParams, Class<?>[] actualParam) {
        if (methodParams == null || methodParams.length != actualParam.length) {
            return false;
        }
        for (int i = 0; i < methodParams.length; ++i) {
            if (IntrospectionUtil.areCompatible(methodParams[i], actualParam[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean areCompatible(Class<?> methodParam, Class<?> actualParam) {
        return methodParam.isAssignableFrom(actualParam) || (methodParam.isPrimitive() ? IntrospectionUtil.areBoxingCompatible(methodParam, actualParam) : IntrospectionUtil.areBoxingCompatible(actualParam, methodParam));
    }

    private static boolean areBoxingCompatible(Class<?> primitiveClass, Class<?> boxedClass) {
        return boxedClass.getSimpleName().toLowerCase(Locale.getDefault()).startsWith(primitiveClass.getSimpleName());
    }

    private static Class<?>[] objectsToClasses(Object ... args) {
        Class[] parameterTypes = new Class[args == null ? 0 : args.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        return parameterTypes;
    }

    public static Object clone(Object original) throws CloneNotSupportedException {
        if (!(original instanceof Cloneable)) {
            throw new CloneNotSupportedException();
        }
        try {
            return original.getClass().getMethod("clone", new Class[0]).invoke(original, new Object[0]);
        }
        catch (Exception e) {
            throw new CloneNotSupportedException();
        }
    }
}

