/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.util.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchingIterator<T>
implements Iterator<T> {
    private final Iterator<T> iterator;
    private final Matcher<?> matcher;
    private T nextElement;
    private boolean nextAvailable = false;

    public MatchingIterator(Iterator<T> iterator, Matcher<?> matcher) {
        this.iterator = iterator;
        this.matcher = matcher;
    }

    private void searchNext() {
        this.nextElement = null;
        while (this.iterator.hasNext() && this.nextElement == null) {
            T n = this.iterator.next();
            if (!this.matcher.matches(n)) continue;
            this.nextElement = n;
        }
        this.nextAvailable = true;
    }

    @Override
    public boolean hasNext() {
        if (!this.nextAvailable) {
            this.searchNext();
        }
        return this.nextElement != null;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T n = this.nextElement;
        this.nextAvailable = false;
        return n;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

