/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.AssertException;
import graphql.GraphQLContext;
import graphql.Internal;
import graphql.Scalars;
import graphql.VisibleForTesting;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.PropertyDataFetcherHelper;
import graphql.util.FpKit;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

@Internal
class ValuesResolverLegacy {
    ValuesResolverLegacy() {
    }

    @VisibleForTesting
    static Value<?> valueToLiteralLegacy(Object value, GraphQLType type, GraphQLContext graphqlContext, Locale locale) {
        Assert.assertTrue(!(value instanceof Value), () -> "Unexpected literal " + value);
        if (value == null) {
            return null;
        }
        if (GraphQLTypeUtil.isNonNull(type)) {
            return ValuesResolverLegacy.handleNonNullLegacy(value, (GraphQLNonNull)type, graphqlContext, locale);
        }
        if (GraphQLTypeUtil.isList(type)) {
            return ValuesResolverLegacy.handleListLegacy(value, (GraphQLList)type, graphqlContext, locale);
        }
        if (type instanceof GraphQLInputObjectType) {
            return ValuesResolverLegacy.handleInputObjectLegacy(value, (GraphQLInputObjectType)type, graphqlContext, locale);
        }
        if (!(type instanceof GraphQLScalarType) && !(type instanceof GraphQLEnumType)) {
            throw new AssertException("Must provide Input Type, cannot use: " + type.getClass());
        }
        Object serialized = ValuesResolverLegacy.serializeLegacy(type, value, graphqlContext, locale);
        if (serialized instanceof Boolean) {
            return BooleanValue.newBooleanValue().value((Boolean)serialized).build();
        }
        String stringValue = serialized.toString();
        if (serialized instanceof Number) {
            return ValuesResolverLegacy.handleNumberLegacy(stringValue);
        }
        if (serialized instanceof String) {
            if (type instanceof GraphQLEnumType) {
                return EnumValue.newEnumValue().name(stringValue).build();
            }
            if (type == Scalars.GraphQLID && stringValue.matches("^[0-9]+$")) {
                return IntValue.newIntValue().value(new BigInteger(stringValue)).build();
            }
            return StringValue.newStringValue().value(stringValue).build();
        }
        throw new AssertException("'Cannot convert value to AST: " + serialized);
    }

    private static Value<?> handleInputObjectLegacy(Object javaValue, GraphQLInputObjectType type, GraphQLContext graphqlContext, Locale locale) {
        List<GraphQLInputObjectField> fields = type.getFields();
        ArrayList<ObjectField> fieldNodes = new ArrayList<ObjectField>();
        fields.forEach(field -> {
            GraphQLInputType fieldType;
            String fieldName = field.getName();
            Object fieldValueObj = PropertyDataFetcherHelper.getPropertyValue(fieldName, javaValue, fieldType = field.getType());
            Value<?> nodeValue = ValuesResolverLegacy.valueToLiteralLegacy(fieldValueObj, fieldType, graphqlContext, locale);
            if (nodeValue != null) {
                fieldNodes.add(ObjectField.newObjectField().name(fieldName).value(nodeValue).build());
            }
        });
        return ObjectValue.newObjectValue().objectFields(fieldNodes).build();
    }

    private static Value<?> handleNumberLegacy(String stringValue) {
        if (stringValue.matches("^[0-9]+$")) {
            return IntValue.newIntValue().value(new BigInteger(stringValue)).build();
        }
        return FloatValue.newFloatValue().value(new BigDecimal(stringValue)).build();
    }

    private static Value<?> handleListLegacy(Object value, GraphQLList type, GraphQLContext graphqlContext, Locale locale) {
        GraphQLType itemType = type.getWrappedType();
        if (FpKit.isIterable(value)) {
            List<Value> valuesNodes = FpKit.toListOrSingletonList(value).stream().map(item -> ValuesResolverLegacy.valueToLiteralLegacy(item, itemType, graphqlContext, locale)).collect(Collectors.toList());
            return ArrayValue.newArrayValue().values(valuesNodes).build();
        }
        return ValuesResolverLegacy.valueToLiteralLegacy(value, itemType, graphqlContext, locale);
    }

    private static Value<?> handleNonNullLegacy(Object _value, GraphQLNonNull type, GraphQLContext graphqlContext, Locale locale) {
        GraphQLType wrappedType = type.getWrappedType();
        return ValuesResolverLegacy.valueToLiteralLegacy(_value, wrappedType, graphqlContext, locale);
    }

    private static Object serializeLegacy(GraphQLType type, Object value, GraphQLContext graphqlContext, Locale locale) {
        if (type instanceof GraphQLScalarType) {
            return ((GraphQLScalarType)type).getCoercing().serialize(value, graphqlContext, locale);
        }
        return ((GraphQLEnumType)type).serialize(value, graphqlContext, locale);
    }
}

