/*
 * Decompiled with CFR 0.152.
 */
package graphql.parser;

import graphql.Assert;
import graphql.Internal;
import graphql.i18n.I18n;
import graphql.language.SourceLocation;
import graphql.parser.UnicodeUtil;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;

@Internal
public class StringValueParsing {
    private static final String ESCAPED_TRIPLE_QUOTES = "\\\\\"\"\"";
    private static final String THREE_QUOTES = "\"\"\"";

    public static String parseTripleQuotedString(String strText) {
        int end = strText.length() - 3;
        String s = strText.substring(3, end);
        s = s.replaceAll(ESCAPED_TRIPLE_QUOTES, THREE_QUOTES);
        return StringValueParsing.removeIndentation(s);
    }

    public static String removeIndentation(String rawValue) {
        int endIndex;
        String line;
        String line2;
        String[] lines = rawValue.split("\\n");
        Integer commonIndent = null;
        for (int i = 0; i < lines.length; ++i) {
            if (i == 0) continue;
            String line3 = lines[i];
            int length = line3.length();
            int indent = StringValueParsing.leadingWhitespace(line3);
            if (indent >= length || commonIndent != null && indent >= commonIndent) continue;
            commonIndent = indent;
        }
        ArrayList<String> lineList = new ArrayList<String>(Arrays.asList(lines));
        if (commonIndent != null) {
            for (int i = 0; i < lineList.size(); ++i) {
                String line4 = (String)lineList.get(i);
                if (i == 0 || line4.length() <= commonIndent) continue;
                line4 = line4.substring(commonIndent);
                lineList.set(i, line4);
            }
        }
        while (!lineList.isEmpty() && StringValueParsing.containsOnlyWhiteSpace(line2 = (String)lineList.get(0))) {
            lineList.remove(0);
        }
        while (!lineList.isEmpty() && StringValueParsing.containsOnlyWhiteSpace(line = (String)lineList.get(endIndex = lineList.size() - 1))) {
            lineList.remove(endIndex);
        }
        StringBuilder formatted = new StringBuilder();
        for (int i = 0; i < lineList.size(); ++i) {
            String line5 = (String)lineList.get(i);
            if (i == 0) {
                formatted.append(line5);
                continue;
            }
            formatted.append("\n");
            formatted.append(line5);
        }
        return formatted.toString();
    }

    private static int leadingWhitespace(String str) {
        char ch;
        int count = 0;
        for (int i = 0; i < str.length() && ((ch = str.charAt(i)) == ' ' || ch == '\t'); ++i) {
            ++count;
        }
        return count;
    }

    private static boolean containsOnlyWhiteSpace(String str) {
        return StringValueParsing.leadingWhitespace(str) == str.length();
    }

    public static String parseSingleQuotedString(I18n i18n, String string, SourceLocation sourceLocation) {
        StringWriter writer = new StringWriter(string.length() - 2);
        int end = string.length() - 1;
        block11: for (int i = 1; i < end; ++i) {
            char c = string.charAt(i);
            if (c != '\\') {
                writer.write(c);
                continue;
            }
            char escaped = string.charAt(i + 1);
            ++i;
            switch (escaped) {
                case '\"': {
                    writer.write(34);
                    continue block11;
                }
                case '/': {
                    writer.write(47);
                    continue block11;
                }
                case '\\': {
                    writer.write(92);
                    continue block11;
                }
                case 'b': {
                    writer.write(8);
                    continue block11;
                }
                case 'f': {
                    writer.write(12);
                    continue block11;
                }
                case 'n': {
                    writer.write(10);
                    continue block11;
                }
                case 'r': {
                    writer.write(13);
                    continue block11;
                }
                case 't': {
                    writer.write(9);
                    continue block11;
                }
                case 'u': {
                    i = UnicodeUtil.parseAndWriteUnicode(i18n, writer, string, i, sourceLocation);
                    continue block11;
                }
                default: {
                    Assert.assertShouldNeverHappen();
                }
            }
        }
        return writer.toString();
    }
}

