/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.DirectivesUtil;
import graphql.Internal;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputObjectTypeExtensionDefinition;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLInputFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLNamedInputType;
import graphql.schema.GraphQLNullableType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.schema.GraphqlDirectivesContainerTypeBuilder;
import graphql.schema.SchemaElementChildrenContainer;
import graphql.util.FpKit;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

@PublicApi
public class GraphQLInputObjectType
implements GraphQLNamedInputType,
GraphQLUnmodifiedType,
GraphQLNullableType,
GraphQLInputFieldsContainer,
GraphQLDirectiveContainer {
    private final String name;
    private final String description;
    private final ImmutableMap<String, GraphQLInputObjectField> fieldMap;
    private final InputObjectTypeDefinition definition;
    private final ImmutableList<InputObjectTypeExtensionDefinition> extensionDefinitions;
    private final DirectivesUtil.DirectivesHolder directives;
    public static final String CHILD_FIELD_DEFINITIONS = "fieldDefinitions";

    @Internal
    private GraphQLInputObjectType(String name, String description, List<GraphQLInputObjectField> fields, List<GraphQLDirective> directives, List<GraphQLAppliedDirective> appliedDirectives, InputObjectTypeDefinition definition, List<InputObjectTypeExtensionDefinition> extensionDefinitions) {
        Assert.assertValidName(name);
        Assert.assertNotNull(fields, () -> "fields can't be null");
        Assert.assertNotNull(directives, () -> "directives cannot be null");
        this.name = name;
        this.description = description;
        this.definition = definition;
        this.extensionDefinitions = ImmutableList.copyOf(extensionDefinitions);
        this.directives = new DirectivesUtil.DirectivesHolder(directives, appliedDirectives);
        this.fieldMap = this.buildDefinitionMap(fields);
    }

    private ImmutableMap<String, GraphQLInputObjectField> buildDefinitionMap(List<GraphQLInputObjectField> fieldDefinitions) {
        return ImmutableMap.copyOf(FpKit.getByName(fieldDefinitions, GraphQLInputObjectField::getName, (fld1, fld2) -> (GraphQLInputObjectField)Assert.assertShouldNeverHappen("Duplicated definition for field '%s' in type '%s'", fld1.getName(), this.name)));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public List<GraphQLInputObjectField> getFields() {
        return this.getFieldDefinitions();
    }

    public GraphQLInputObjectField getField(String name) {
        return this.fieldMap.get(name);
    }

    @Override
    public List<GraphQLDirective> getDirectives() {
        return this.directives.getDirectives();
    }

    @Override
    public Map<String, GraphQLDirective> getDirectivesByName() {
        return this.directives.getDirectivesByName();
    }

    @Override
    public Map<String, List<GraphQLDirective>> getAllDirectivesByName() {
        return this.directives.getAllDirectivesByName();
    }

    @Override
    public GraphQLDirective getDirective(String directiveName) {
        return this.directives.getDirective(directiveName);
    }

    @Override
    public List<GraphQLAppliedDirective> getAppliedDirectives() {
        return this.directives.getAppliedDirectives();
    }

    @Override
    public Map<String, List<GraphQLAppliedDirective>> getAllAppliedDirectivesByName() {
        return this.directives.getAllAppliedDirectivesByName();
    }

    @Override
    public GraphQLAppliedDirective getAppliedDirective(String directiveName) {
        return this.directives.getAppliedDirective(directiveName);
    }

    @Override
    public GraphQLInputObjectField getFieldDefinition(String name) {
        return this.fieldMap.get(name);
    }

    @Override
    public List<GraphQLInputObjectField> getFieldDefinitions() {
        return ImmutableList.copyOf(this.fieldMap.values());
    }

    @Override
    public InputObjectTypeDefinition getDefinition() {
        return this.definition;
    }

    public List<InputObjectTypeExtensionDefinition> getExtensionDefinitions() {
        return this.extensionDefinitions;
    }

    public GraphQLInputObjectType transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphQLInputObjectType.newInputObject(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    @Override
    public GraphQLSchemaElement copy() {
        return GraphQLInputObjectType.newInputObject(this).build();
    }

    @Override
    public TraversalControl accept(TraverserContext<GraphQLSchemaElement> context, GraphQLTypeVisitor visitor) {
        return visitor.visitGraphQLInputObjectType(this, context);
    }

    @Override
    public List<GraphQLSchemaElement> getChildren() {
        ArrayList<GraphQLSchemaElement> children = new ArrayList<GraphQLSchemaElement>(this.fieldMap.values());
        children.addAll(this.directives.getDirectives());
        children.addAll(this.directives.getAppliedDirectives());
        return children;
    }

    @Override
    public SchemaElementChildrenContainer getChildrenWithTypeReferences() {
        return SchemaElementChildrenContainer.newSchemaElementChildrenContainer().children(CHILD_FIELD_DEFINITIONS, this.fieldMap.values()).children("directives", this.directives.getDirectives()).children("appliedDirectives", this.directives.getAppliedDirectives()).build();
    }

    @Override
    public GraphQLInputObjectType withNewChildren(SchemaElementChildrenContainer newChildren) {
        return this.transform(builder -> builder.replaceFields(newChildren.getChildren(CHILD_FIELD_DEFINITIONS)).replaceDirectives(newChildren.getChildren("directives")).replaceAppliedDirectives(newChildren.getChildren("appliedDirectives")));
    }

    @Override
    public final boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return "GraphQLInputObjectType{name='" + this.name + "', description='" + this.description + "', fieldMap=" + this.fieldMap + ", definition=" + this.definition + ", directives=" + this.directives + "}";
    }

    public static Builder newInputObject(GraphQLInputObjectType existing) {
        return new Builder(existing);
    }

    public static Builder newInputObject() {
        return new Builder();
    }

    @PublicApi
    public static class Builder
    extends GraphqlDirectivesContainerTypeBuilder<Builder, Builder> {
        private InputObjectTypeDefinition definition;
        private List<InputObjectTypeExtensionDefinition> extensionDefinitions = ImmutableKit.emptyList();
        private final Map<String, GraphQLInputObjectField> fields = new LinkedHashMap<String, GraphQLInputObjectField>();

        public Builder() {
        }

        public Builder(GraphQLInputObjectType existing) {
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.definition = existing.getDefinition();
            this.extensionDefinitions = existing.getExtensionDefinitions();
            this.fields.putAll(FpKit.getByName(existing.getFields(), GraphQLInputObjectField::getName));
            this.copyExistingDirectives(existing);
        }

        public Builder definition(InputObjectTypeDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder extensionDefinitions(List<InputObjectTypeExtensionDefinition> extensionDefinitions) {
            this.extensionDefinitions = extensionDefinitions;
            return this;
        }

        public Builder field(GraphQLInputObjectField field) {
            Assert.assertNotNull(field, () -> "field can't be null");
            this.fields.put(field.getName(), field);
            return this;
        }

        public Builder field(UnaryOperator<GraphQLInputObjectField.Builder> builderFunction) {
            Assert.assertNotNull(builderFunction, () -> "builderFunction should not be null");
            GraphQLInputObjectField.Builder builder = GraphQLInputObjectField.newInputObjectField();
            builder = (GraphQLInputObjectField.Builder)builderFunction.apply(builder);
            return this.field(builder);
        }

        public Builder field(GraphQLInputObjectField.Builder builder) {
            return this.field(builder.build());
        }

        public Builder fields(List<GraphQLInputObjectField> fields) {
            fields.forEach(this::field);
            return this;
        }

        public Builder replaceFields(List<GraphQLInputObjectField> fields) {
            this.fields.clear();
            fields.forEach(this::field);
            return this;
        }

        public boolean hasField(String fieldName) {
            return this.fields.containsKey(fieldName);
        }

        public Builder clearFields() {
            this.fields.clear();
            return this;
        }

        @Override
        public Builder replaceDirectives(List<GraphQLDirective> directives) {
            return (Builder)super.replaceDirectives(directives);
        }

        @Override
        public Builder withDirectives(GraphQLDirective ... directives) {
            return (Builder)super.withDirectives(directives);
        }

        @Override
        public Builder withDirective(GraphQLDirective directive) {
            return (Builder)super.withDirective(directive);
        }

        @Override
        public Builder withDirective(GraphQLDirective.Builder builder) {
            return (Builder)super.withDirective(builder);
        }

        @Override
        public Builder clearDirectives() {
            return (Builder)super.clearDirectives();
        }

        @Override
        public Builder name(String name) {
            return (Builder)super.name(name);
        }

        @Override
        public Builder description(String description) {
            return (Builder)super.description(description);
        }

        public GraphQLInputObjectType build() {
            return new GraphQLInputObjectType(this.name, this.description, this.sort(this.fields, GraphQLInputObjectType.class, GraphQLInputObjectField.class), this.sort(this.directives, GraphQLInputObjectType.class, GraphQLDirective.class), this.sort(this.appliedDirectives, GraphQLInputObjectType.class, GraphQLAppliedDirective.class), this.definition, this.extensionDefinitions);
        }
    }
}

