/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.diffing;

import graphql.Assert;
import graphql.Internal;
import graphql.com.google.common.collect.HashMultiset;
import graphql.com.google.common.collect.Multiset;
import graphql.com.google.common.collect.Multisets;
import graphql.schema.diffing.Edge;
import graphql.schema.diffing.EditOperation;
import graphql.schema.diffing.EditorialCostForMapping;
import graphql.schema.diffing.HungarianAlgorithm;
import graphql.schema.diffing.Mapping;
import graphql.schema.diffing.PossibleMappingsCalculator;
import graphql.schema.diffing.SchemaDiffingRunningCheck;
import graphql.schema.diffing.SchemaGraph;
import graphql.schema.diffing.Vertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

@Internal
public class DiffImpl {
    private final PossibleMappingsCalculator possibleMappingsCalculator;
    private final SchemaGraph completeSourceGraph;
    private final SchemaGraph completeTargetGraph;
    private final PossibleMappingsCalculator.PossibleMappings possibleMappings;
    private final SchemaDiffingRunningCheck runningCheck;

    public DiffImpl(PossibleMappingsCalculator possibleMappingsCalculator, SchemaGraph completeSourceGraph, SchemaGraph completeTargetGraph, PossibleMappingsCalculator.PossibleMappings possibleMappings, SchemaDiffingRunningCheck runningCheck) {
        this.possibleMappingsCalculator = possibleMappingsCalculator;
        this.completeSourceGraph = completeSourceGraph;
        this.completeTargetGraph = completeTargetGraph;
        this.possibleMappings = possibleMappings;
        this.runningCheck = runningCheck;
    }

    OptimalEdit diffImpl(Mapping startMapping, List<Vertex> allSources, List<Vertex> allTargets, AtomicInteger algoIterationCount) throws Exception {
        int graphSize = allSources.size();
        int fixedEditorialCost = EditorialCostForMapping.baseEditorialCostForMapping(startMapping, this.completeSourceGraph, this.completeTargetGraph);
        int level = startMapping.size();
        ArrayList<Vertex> allNonFixedTargets = new ArrayList<Vertex>(allTargets);
        startMapping.forEachTarget(allNonFixedTargets::remove);
        MappingEntry firstMappingEntry = new MappingEntry(startMapping, level, fixedEditorialCost);
        firstMappingEntry.availableTargetVertices = allNonFixedTargets;
        OptimalEdit optimalEdit = new OptimalEdit(this.completeSourceGraph, this.completeTargetGraph);
        PriorityQueue<MappingEntry> queue = new PriorityQueue<MappingEntry>((mappingEntry1, mappingEntry2) -> {
            int compareResult = Double.compare(mappingEntry1.lowerBoundCost, mappingEntry2.lowerBoundCost);
            if (compareResult == 0) {
                return Integer.compare(mappingEntry2.level, mappingEntry1.level);
            }
            return compareResult;
        });
        queue.add(firstMappingEntry);
        while (!queue.isEmpty()) {
            MappingEntry mappingEntry = (MappingEntry)queue.poll();
            algoIterationCount.incrementAndGet();
            if (mappingEntry.lowerBoundCost >= (double)optimalEdit.ged) break;
            if (mappingEntry.level > 0 && !mappingEntry.mappingEntriesSiblings.isEmpty()) {
                this.addSiblingToQueue(fixedEditorialCost, mappingEntry.level, queue, optimalEdit, allSources, allTargets, mappingEntry);
            }
            if (mappingEntry.level < graphSize) {
                this.addChildToQueue(fixedEditorialCost, mappingEntry, queue, optimalEdit, allSources, allTargets);
            }
            this.runningCheck.check();
        }
        return optimalEdit;
    }

    private void addChildToQueue(int fixedEditorialCost, MappingEntry parentEntry, PriorityQueue<MappingEntry> queue, OptimalEdit optimalEdit, List<Vertex> allSources, List<Vertex> allTargets) {
        Mapping parentPartialMapping = parentEntry.partialMapping;
        int parentLevel = parentEntry.level;
        int level = parentLevel + 1;
        Assert.assertTrue(parentLevel == parentPartialMapping.size());
        ArrayList<Vertex> availableTargetVertices = new ArrayList<Vertex>(parentEntry.availableTargetVertices);
        availableTargetVertices.remove(parentPartialMapping.getTarget(parentLevel - 1));
        Assert.assertTrue(availableTargetVertices.size() + parentPartialMapping.size() == allTargets.size());
        Vertex v_i = allSources.get(parentLevel);
        int costMatrixSize = allSources.size() - parentLevel;
        double[][] costMatrixForHungarianAlgo = new double[costMatrixSize][costMatrixSize];
        double[][] costMatrix = new double[costMatrixSize][costMatrixSize];
        LinkedHashMap<Vertex, Double> isolatedVerticesCache = new LinkedHashMap<Vertex, Double>();
        Map<Vertex, Vertex> nonFixedParentRestrictions = this.possibleMappingsCalculator.getNonFixedParentRestrictions(this.completeSourceGraph, this.completeTargetGraph, parentPartialMapping);
        for (int i = parentLevel; i < allSources.size(); ++i) {
            Vertex v = allSources.get(i);
            int j = 0;
            for (Vertex u : availableTargetVertices) {
                double cost;
                costMatrixForHungarianAlgo[i - parentLevel][j] = cost = this.calcLowerBoundMappingCost(v, u, parentPartialMapping, isolatedVerticesCache, nonFixedParentRestrictions);
                costMatrix[i - parentLevel][j] = cost;
                ++j;
            }
            this.runningCheck.check();
        }
        HungarianAlgorithm hungarianAlgorithm = new HungarianAlgorithm(costMatrixForHungarianAlgo);
        int[] assignments = hungarianAlgorithm.execute();
        int editorialCostForMapping = EditorialCostForMapping.editorialCostForMapping(fixedEditorialCost, parentPartialMapping, this.completeSourceGraph, this.completeTargetGraph);
        double costMatrixSum = this.getCostMatrixSum(costMatrix, assignments);
        double lowerBoundForPartialMapping = (double)editorialCostForMapping + costMatrixSum;
        Mapping newMapping = parentPartialMapping.extendMapping(v_i, availableTargetVertices.get(assignments[0]));
        if (lowerBoundForPartialMapping >= (double)optimalEdit.ged) {
            return;
        }
        MappingEntry newMappingEntry = new MappingEntry(newMapping, level, lowerBoundForPartialMapping);
        LinkedBlockingQueue<MappingEntry> siblings = new LinkedBlockingQueue<MappingEntry>();
        newMappingEntry.mappingEntriesSiblings = siblings;
        newMappingEntry.assignments = assignments;
        newMappingEntry.availableTargetVertices = availableTargetVertices;
        queue.add(newMappingEntry);
        this.expandMappingAndUpdateOptimalMapping(fixedEditorialCost, level, optimalEdit, allSources, parentPartialMapping.copy(), assignments, availableTargetVertices, lowerBoundForPartialMapping);
        this.calculateRestOfChildren(availableTargetVertices, hungarianAlgorithm, costMatrix, editorialCostForMapping, parentPartialMapping, v_i, optimalEdit.ged, level, siblings);
    }

    private void updateOptimalEdit(OptimalEdit optimalEdit, int newGed, Mapping mapping) {
        Assert.assertTrue(newGed < optimalEdit.ged);
        optimalEdit.ged = newGed;
        optimalEdit.mapping = mapping;
    }

    private void calculateRestOfChildren(List<Vertex> availableTargetVertices, HungarianAlgorithm hungarianAlgorithm, double[][] costMatrixCopy, double editorialCostForMapping, Mapping partialMapping, Vertex v_i, int upperBound, int level, LinkedBlockingQueue<MappingEntry> siblings) {
        int[] assignments;
        for (int child = 1; child < availableTargetVertices.size() && hungarianAlgorithm.costMatrix[0][(assignments = hungarianAlgorithm.nextChild())[0]] != 2.147483647E9; ++child) {
            double costMatrixSumSibling = this.getCostMatrixSum(costMatrixCopy, assignments);
            double lowerBoundForPartialMappingSibling = editorialCostForMapping + costMatrixSumSibling;
            Mapping newMappingSibling = partialMapping.extendMapping(v_i, availableTargetVertices.get(assignments[0]));
            if (lowerBoundForPartialMappingSibling >= (double)upperBound) break;
            MappingEntry sibling = new MappingEntry(newMappingSibling, level, lowerBoundForPartialMappingSibling);
            sibling.mappingEntriesSiblings = siblings;
            sibling.assignments = assignments;
            sibling.availableTargetVertices = availableTargetVertices;
            siblings.add(sibling);
            this.runningCheck.check();
        }
    }

    private void addSiblingToQueue(int fixedEditorialCost, int level, PriorityQueue<MappingEntry> queue, OptimalEdit optimalEdit, List<Vertex> allSources, List<Vertex> allTargets, MappingEntry mappingEntry) throws InterruptedException {
        Assert.assertFalse(mappingEntry.mappingEntriesSiblings.isEmpty());
        MappingEntry sibling = mappingEntry.mappingEntriesSiblings.take();
        if (sibling.lowerBoundCost < (double)optimalEdit.ged) {
            queue.add(sibling);
            Mapping toExpand = sibling.partialMapping.copyMappingWithLastElementRemoved();
            this.expandMappingAndUpdateOptimalMapping(fixedEditorialCost, level, optimalEdit, allSources, toExpand, sibling.assignments, sibling.availableTargetVertices, sibling.lowerBoundCost);
        }
    }

    private void expandMappingAndUpdateOptimalMapping(int fixedEditorialCost, int level, OptimalEdit optimalEdit, List<Vertex> allSources, Mapping toExpand, int[] assignments, List<Vertex> availableTargetVertices, double lowerBoundCost) {
        for (int i = 0; i < assignments.length; ++i) {
            toExpand.add(allSources.get(level - 1 + i), availableTargetVertices.get(assignments[i]));
        }
        Assert.assertTrue(toExpand.size() == this.completeSourceGraph.size());
        int costForFullMapping = EditorialCostForMapping.editorialCostForMapping(fixedEditorialCost, toExpand, this.completeSourceGraph, this.completeTargetGraph);
        Assert.assertTrue(lowerBoundCost <= (double)costForFullMapping);
        if (costForFullMapping < optimalEdit.ged) {
            this.updateOptimalEdit(optimalEdit, costForFullMapping, toExpand);
        }
    }

    private double getCostMatrixSum(double[][] costMatrix, int[] assignments) {
        double costMatrixSum = 0.0;
        for (int i = 0; i < assignments.length; ++i) {
            costMatrixSum += costMatrix[i][assignments[i]];
        }
        return costMatrixSum;
    }

    private double calcLowerBoundMappingCost(Vertex v, Vertex u, Mapping partialMapping, Map<Vertex, Double> isolatedVerticesCache, Map<Vertex, Vertex> nonFixedParentRestrictions) {
        if (nonFixedParentRestrictions.containsKey(v) || partialMapping.hasParentRestriction(v)) {
            Collection<Edge> parentEdges;
            Vertex uParentRestriction = nonFixedParentRestrictions.get(v);
            if (uParentRestriction == null) {
                uParentRestriction = partialMapping.getParentRestriction(v);
            }
            if ((parentEdges = this.completeTargetGraph.getAdjacentEdgesInverseNonCopy(u)).size() != 1) {
                return 2.147483647E9;
            }
            Vertex uParent = parentEdges.iterator().next().getFrom();
            if (uParent != uParentRestriction) {
                return 2.147483647E9;
            }
        }
        if (!this.possibleMappings.mappingPossible(v, u)) {
            return 2.147483647E9;
        }
        if (u.isOfType("__ISOLATED")) {
            if (isolatedVerticesCache.containsKey(v)) {
                return isolatedVerticesCache.get(v);
            }
            double result = this.calcLowerBoundMappingCostForIsolated(v, partialMapping, true);
            isolatedVerticesCache.put(v, result);
            return result;
        }
        if (v.isOfType("__ISOLATED")) {
            if (isolatedVerticesCache.containsKey(u)) {
                return isolatedVerticesCache.get(u);
            }
            double result = this.calcLowerBoundMappingCostForIsolated(u, partialMapping, false);
            isolatedVerticesCache.put(u, result);
            return result;
        }
        boolean equalNodes = v.getType().equals(u.getType()) && v.getProperties().equals(u.getProperties());
        Collection<Edge> adjacentEdgesV = this.completeSourceGraph.getAdjacentEdgesNonCopy(v);
        HashMultiset<String> multisetLabelsV = HashMultiset.create();
        for (Edge edge : adjacentEdgesV) {
            if (partialMapping.containsSource(edge.getTo())) continue;
            multisetLabelsV.add(edge.getLabel());
        }
        Collection<Edge> adjacentEdgesU = this.completeTargetGraph.getAdjacentEdgesNonCopy(u);
        HashMultiset<String> multisetLabelsU = HashMultiset.create();
        for (Edge edge : adjacentEdgesU) {
            if (partialMapping.containsTarget(edge.getTo())) continue;
            multisetLabelsU.add(edge.getLabel());
        }
        int anchoredVerticesCost = this.calcAnchoredVerticesCost(v, u, partialMapping);
        Multiset intersection = Multisets.intersection(multisetLabelsV, multisetLabelsU);
        int multiSetEditDistance = Math.max(multisetLabelsV.size(), multisetLabelsU.size()) - intersection.size();
        double result = (equalNodes ? 0 : 1) + multiSetEditDistance + anchoredVerticesCost;
        return result;
    }

    private int calcAnchoredVerticesCost(Vertex v, Vertex u, Mapping partialMapping) {
        int anchoredVerticesCost = 0;
        Collection<Edge> adjacentEdgesV = this.completeSourceGraph.getAdjacentEdgesNonCopy(v);
        Collection<Edge> adjacentEdgesU = this.completeTargetGraph.getAdjacentEdgesNonCopy(u);
        Collection<Edge> adjacentEdgesInverseV = this.completeSourceGraph.getAdjacentEdgesInverseNonCopy(v);
        Collection<Edge> adjacentEdgesInverseU = this.completeTargetGraph.getAdjacentEdgesInverseNonCopy(u);
        LinkedHashSet<Edge> matchedTargetEdges = new LinkedHashSet<Edge>();
        LinkedHashSet<Edge> matchedTargetEdgesInverse = new LinkedHashSet<Edge>();
        block0: for (Edge edgeV : adjacentEdgesV) {
            if (!partialMapping.containsSource(edgeV.getTo())) continue;
            for (Edge edgeU : adjacentEdgesU) {
                if (partialMapping.getTarget(edgeV.getTo()) != edgeU.getTo()) continue;
                matchedTargetEdges.add(edgeU);
                if (Objects.equals(edgeV.getLabel(), edgeU.getLabel())) continue block0;
                ++anchoredVerticesCost;
                continue block0;
            }
            ++anchoredVerticesCost;
        }
        block2: for (Edge edgeV : adjacentEdgesInverseV) {
            if (!partialMapping.containsSource(edgeV.getFrom())) continue;
            for (Edge edgeU : adjacentEdgesInverseU) {
                if (partialMapping.getTarget(edgeV.getFrom()) != edgeU.getFrom()) continue;
                matchedTargetEdgesInverse.add(edgeU);
                if (Objects.equals(edgeV.getLabel(), edgeU.getLabel())) continue block2;
                ++anchoredVerticesCost;
                continue block2;
            }
            ++anchoredVerticesCost;
        }
        for (Edge edgeU : adjacentEdgesU) {
            if (!partialMapping.containsTarget(edgeU.getTo()) || matchedTargetEdges.contains(edgeU)) continue;
            ++anchoredVerticesCost;
        }
        for (Edge edgeU : adjacentEdgesInverseU) {
            if (!partialMapping.containsTarget(edgeU.getFrom()) || matchedTargetEdgesInverse.contains(edgeU)) continue;
            ++anchoredVerticesCost;
        }
        return anchoredVerticesCost;
    }

    private double calcLowerBoundMappingCostForIsolated(Vertex vertex, Mapping partialMapping, boolean sourceOrTarget) {
        SchemaGraph schemaGraph = sourceOrTarget ? this.completeSourceGraph : this.completeTargetGraph;
        Collection<Edge> adjacentEdges = schemaGraph.getAdjacentEdgesNonCopy(vertex);
        int anchoredInverseEdges = 0;
        Collection<Edge> adjacentEdgesInverse = schemaGraph.getAdjacentEdgesInverseNonCopy(vertex);
        for (Edge edge : adjacentEdgesInverse) {
            if (!partialMapping.contains(edge.getFrom(), sourceOrTarget)) continue;
            ++anchoredInverseEdges;
        }
        return 1 + adjacentEdges.size() + anchoredInverseEdges;
    }

    public static class OptimalEdit {
        private final SchemaGraph completeSourceGraph;
        private final SchemaGraph completeTargetGraph;
        public Mapping mapping;
        public int ged = Integer.MAX_VALUE;

        public OptimalEdit(SchemaGraph completeSourceGraph, SchemaGraph completeTargetGraph) {
            this.completeSourceGraph = completeSourceGraph;
            this.completeTargetGraph = completeTargetGraph;
        }

        public OptimalEdit(SchemaGraph completeSourceGraph, SchemaGraph completeTargetGraph, Mapping mapping, int ged) {
            this.completeSourceGraph = completeSourceGraph;
            this.completeTargetGraph = completeTargetGraph;
            this.mapping = mapping;
            this.ged = ged;
        }

        public List<EditOperation> getListOfEditOperations() {
            ArrayList<EditOperation> listOfEditOperations = new ArrayList<EditOperation>();
            Assert.assertTrue(EditorialCostForMapping.baseEditorialCostForMapping(this.mapping, this.completeSourceGraph, this.completeTargetGraph, listOfEditOperations) == this.ged);
            return listOfEditOperations;
        }
    }

    private static class MappingEntry {
        public LinkedBlockingQueue<MappingEntry> mappingEntriesSiblings = new LinkedBlockingQueue();
        public int[] assignments;
        public List<Vertex> availableTargetVertices;
        Mapping partialMapping;
        int level;
        double lowerBoundCost;

        public MappingEntry(Mapping partialMapping, int level, double lowerBoundCost) {
            this.partialMapping = partialMapping;
            this.level = level;
            this.lowerBoundCost = lowerBoundCost;
        }
    }
}

