/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.Internal;
import graphql.language.Definition;
import graphql.language.DirectiveDefinition;
import graphql.language.Document;
import graphql.language.FragmentDefinition;
import graphql.language.OperationDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.TypeDefinition;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;

@Internal
public class ExecutableDefinitions
extends AbstractRule {
    public ExecutableDefinitions(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkDocument(Document document) {
        document.getDefinitions().forEach(definition -> {
            if (!(definition instanceof OperationDefinition) && !(definition instanceof FragmentDefinition)) {
                String message = this.nonExecutableDefinitionMessage((Definition)definition);
                this.addError(ValidationErrorType.NonExecutableDefinition, definition.getSourceLocation(), message);
            }
        });
    }

    private String nonExecutableDefinitionMessage(Definition definition) {
        if (definition instanceof TypeDefinition) {
            return this.i18n(ValidationErrorType.NonExecutableDefinition, "ExecutableDefinitions.notExecutableType", ((TypeDefinition)definition).getName());
        }
        if (definition instanceof SchemaDefinition) {
            return this.i18n(ValidationErrorType.NonExecutableDefinition, "ExecutableDefinitions.notExecutableSchema", new Object[0]);
        }
        if (definition instanceof DirectiveDefinition) {
            return this.i18n(ValidationErrorType.NonExecutableDefinition, "ExecutableDefinitions.notExecutableDirective", ((DirectiveDefinition)definition).getName());
        }
        return this.i18n(ValidationErrorType.NonExecutableDefinition, "ExecutableDefinitions.notExecutableDefinition", new Object[0]);
    }
}

