/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font;

import com.itextpdf.io.font.Pfm2afm;
import com.itextpdf.io.font.constants.StandardFonts;
import com.itextpdf.io.source.RandomAccessFileOrArray;
import com.itextpdf.io.source.RandomAccessSourceFactory;
import com.itextpdf.io.util.ResourceUtil;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

class Type1Parser {
    private static final String AFM_HEADER = "StartFontMetrics";
    private String afmPath;
    private String pfbPath;
    private byte[] pfbData;
    private byte[] afmData;
    private boolean isBuiltInFont;
    private RandomAccessSourceFactory sourceFactory = new RandomAccessSourceFactory();

    public Type1Parser(String metricsPath, String binaryPath, byte[] afm, byte[] pfb) {
        this.afmData = afm;
        this.pfbData = pfb;
        this.afmPath = metricsPath;
        this.pfbPath = binaryPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomAccessFileOrArray getMetricsFile() throws IOException {
        this.isBuiltInFont = false;
        if (StandardFonts.isStandardFont(this.afmPath)) {
            this.isBuiltInFont = true;
            byte[] buf = new byte[1024];
            InputStream resource = null;
            try {
                int read;
                String resourcePath = "com/itextpdf/io/font/afm/" + this.afmPath + ".afm";
                resource = ResourceUtil.getResourceStream(resourcePath);
                if (resource == null) {
                    throw new com.itextpdf.io.exceptions.IOException("{0} was not found as resource.").setMessageParams(resourcePath);
                }
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                while ((read = resource.read(buf)) >= 0) {
                    stream.write(buf, 0, read);
                }
                buf = stream.toByteArray();
            }
            finally {
                if (resource != null) {
                    try {
                        resource.close();
                    }
                    catch (Exception resourcePath) {}
                }
            }
            return new RandomAccessFileOrArray(this.sourceFactory.createSource(buf));
        }
        if (this.afmPath != null) {
            if (this.afmPath.toLowerCase().endsWith(".afm")) {
                return new RandomAccessFileOrArray(this.sourceFactory.createBestSource(this.afmPath));
            }
            if (this.afmPath.toLowerCase().endsWith(".pfm")) {
                ByteArrayOutputStream ba = new ByteArrayOutputStream();
                RandomAccessFileOrArray rf = new RandomAccessFileOrArray(this.sourceFactory.createBestSource(this.afmPath));
                Pfm2afm.convert(rf, ba);
                rf.close();
                return new RandomAccessFileOrArray(this.sourceFactory.createSource(ba.toByteArray()));
            }
            throw new com.itextpdf.io.exceptions.IOException("{0} is not an afm or pfm font file.").setMessageParams(this.afmPath);
        }
        if (this.afmData != null) {
            RandomAccessFileOrArray rf = new RandomAccessFileOrArray(this.sourceFactory.createSource(this.afmData));
            if (this.isAfmFile(rf)) {
                return rf;
            }
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            try {
                Pfm2afm.convert(rf, ba);
            }
            catch (Exception ignored) {
                throw new com.itextpdf.io.exceptions.IOException("Invalid afm or pfm font file.");
            }
            finally {
                rf.close();
            }
            return new RandomAccessFileOrArray(this.sourceFactory.createSource(ba.toByteArray()));
        }
        throw new com.itextpdf.io.exceptions.IOException("Invalid afm or pfm font file.");
    }

    public RandomAccessFileOrArray getPostscriptBinary() throws IOException {
        if (this.pfbData != null) {
            return new RandomAccessFileOrArray(this.sourceFactory.createSource(this.pfbData));
        }
        if (this.pfbPath != null && this.pfbPath.toLowerCase().endsWith(".pfb")) {
            return new RandomAccessFileOrArray(this.sourceFactory.createBestSource(this.pfbPath));
        }
        this.pfbPath = this.afmPath.substring(0, this.afmPath.length() - 3) + "pfb";
        return new RandomAccessFileOrArray(this.sourceFactory.createBestSource(this.pfbPath));
    }

    public boolean isBuiltInFont() {
        return this.isBuiltInFont;
    }

    public String getAfmPath() {
        return this.afmPath;
    }

    private boolean isAfmFile(RandomAccessFileOrArray raf) throws IOException {
        StringBuilder builder = new StringBuilder(AFM_HEADER.length());
        for (int i = 0; i < AFM_HEADER.length(); ++i) {
            try {
                builder.append((char)raf.readByte());
                continue;
            }
            catch (EOFException e) {
                raf.seek(0L);
                return false;
            }
        }
        raf.seek(0L);
        return AFM_HEADER.equals(builder.toString());
    }
}

